/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.entityoperator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.common.HasConfigurableLogging;
import io.strimzi.api.kafka.model.common.HasLivenessProbe;
import io.strimzi.api.kafka.model.common.HasReadinessProbe;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"watchedNamespace", "image", "reconciliationIntervalSeconds", "zookeeperSessionTimeoutSeconds", "secretPrefix", "livenessProbe", "readinessProbe", "resources", "logging", "jvmOptions"})
public class EntityUserOperatorSpec
implements HasConfigurableLogging,
HasLivenessProbe,
HasReadinessProbe,
UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BOOTSTRAP_SERVERS_PORT = 9091;
    public static final long DEFAULT_FULL_RECONCILIATION_INTERVAL_SECONDS = 120L;
    public static final String DEFAULT_SECRET_PREFIX = "";
    private String watchedNamespace;
    private String image;
    private String secretPrefix;
    private long reconciliationIntervalSeconds = 120L;
    private Long zookeeperSessionTimeoutSeconds;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private ResourceRequirements resources;
    private Logging logging;
    private JvmOptions jvmOptions;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="The namespace the User Operator should watch.")
    public String getWatchedNamespace() {
        return this.watchedNamespace;
    }

    public void setWatchedNamespace(String watchedNamespace) {
        this.watchedNamespace = watchedNamespace;
    }

    @Description(value="The image to use for the User Operator")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Description(value="Interval between periodic reconciliations.")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public long getReconciliationIntervalSeconds() {
        return this.reconciliationIntervalSeconds;
    }

    public void setReconciliationIntervalSeconds(long reconciliationIntervalSeconds) {
        this.reconciliationIntervalSeconds = reconciliationIntervalSeconds;
    }

    @Description(value="Timeout for the ZooKeeper session")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @DeprecatedProperty(description="This property has been deprecated because ZooKeeper is not used anymore by the User Operator.")
    @PresentInVersions(value="v1alpha1-v1beta2")
    @Deprecated
    public Long getZookeeperSessionTimeoutSeconds() {
        return this.zookeeperSessionTimeoutSeconds;
    }

    public void setZookeeperSessionTimeoutSeconds(Long zookeeperSessionTimeoutSeconds) {
        this.zookeeperSessionTimeoutSeconds = zookeeperSessionTimeoutSeconds;
    }

    @Description(value="CPU and memory resources to reserve.")
    @KubeLink(group="core", version="v1", kind="resourcerequirements")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod liveness checking.")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    @Override
    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod readiness checking.")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    @Override
    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @Override
    @Description(value="Logging configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Logging getLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JVM Options for pods")
    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(JvmOptions jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="The prefix that will be added to the KafkaUser name to be used as the Secret name.")
    public String getSecretPrefix() {
        return this.secretPrefix;
    }

    public void setSecretPrefix(String secretPrefix) {
        this.secretPrefix = secretPrefix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityUserOperatorSpec)) {
            return false;
        }
        EntityUserOperatorSpec other = (EntityUserOperatorSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReconciliationIntervalSeconds() != other.getReconciliationIntervalSeconds()) {
            return false;
        }
        Long this$zookeeperSessionTimeoutSeconds = this.getZookeeperSessionTimeoutSeconds();
        Long other$zookeeperSessionTimeoutSeconds = other.getZookeeperSessionTimeoutSeconds();
        if (this$zookeeperSessionTimeoutSeconds == null ? other$zookeeperSessionTimeoutSeconds != null : !((Object)this$zookeeperSessionTimeoutSeconds).equals(other$zookeeperSessionTimeoutSeconds)) {
            return false;
        }
        String this$watchedNamespace = this.getWatchedNamespace();
        String other$watchedNamespace = other.getWatchedNamespace();
        if (this$watchedNamespace == null ? other$watchedNamespace != null : !this$watchedNamespace.equals(other$watchedNamespace)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$secretPrefix = this.getSecretPrefix();
        String other$secretPrefix = other.getSecretPrefix();
        if (this$secretPrefix == null ? other$secretPrefix != null : !this$secretPrefix.equals(other$secretPrefix)) {
            return false;
        }
        Probe this$livenessProbe = this.getLivenessProbe();
        Probe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.getReadinessProbe();
        Probe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        Logging this$logging = this.getLogging();
        Logging other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !((Object)this$logging).equals(other$logging)) {
            return false;
        }
        JvmOptions this$jvmOptions = this.getJvmOptions();
        JvmOptions other$jvmOptions = other.getJvmOptions();
        if (this$jvmOptions == null ? other$jvmOptions != null : !((Object)this$jvmOptions).equals(other$jvmOptions)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityUserOperatorSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $reconciliationIntervalSeconds = this.getReconciliationIntervalSeconds();
        result = result * 59 + (int)($reconciliationIntervalSeconds >>> 32 ^ $reconciliationIntervalSeconds);
        Long $zookeeperSessionTimeoutSeconds = this.getZookeeperSessionTimeoutSeconds();
        result = result * 59 + ($zookeeperSessionTimeoutSeconds == null ? 43 : ((Object)$zookeeperSessionTimeoutSeconds).hashCode());
        String $watchedNamespace = this.getWatchedNamespace();
        result = result * 59 + ($watchedNamespace == null ? 43 : $watchedNamespace.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $secretPrefix = this.getSecretPrefix();
        result = result * 59 + ($secretPrefix == null ? 43 : $secretPrefix.hashCode());
        Probe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        Logging $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : ((Object)$logging).hashCode());
        JvmOptions $jvmOptions = this.getJvmOptions();
        result = result * 59 + ($jvmOptions == null ? 43 : ((Object)$jvmOptions).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

