/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GenericKafkaListenerConfigurationBootstrapFluent<A extends GenericKafkaListenerConfigurationBootstrapFluent<A>>
extends BaseFluent<A> {
    private List<String> alternativeNames;
    private String host;
    private Map<String, String> annotations;
    private Map<String, String> labels;
    private Integer nodePort;
    private String loadBalancerIP;

    public GenericKafkaListenerConfigurationBootstrapFluent() {
    }

    public GenericKafkaListenerConfigurationBootstrapFluent(GenericKafkaListenerConfigurationBootstrap instance) {
        GenericKafkaListenerConfigurationBootstrap genericKafkaListenerConfigurationBootstrap = instance = instance != null ? instance : new GenericKafkaListenerConfigurationBootstrap();
        if (instance != null) {
            this.withAlternativeNames(instance.getAlternativeNames());
            this.withHost(instance.getHost());
            this.withAnnotations(instance.getAnnotations());
            this.withLabels(instance.getLabels());
            this.withNodePort(instance.getNodePort());
            this.withLoadBalancerIP(instance.getLoadBalancerIP());
        }
    }

    public A addToAlternativeNames(int index, String item) {
        if (this.alternativeNames == null) {
            this.alternativeNames = new ArrayList<String>();
        }
        this.alternativeNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToAlternativeNames(int index, String item) {
        if (this.alternativeNames == null) {
            this.alternativeNames = new ArrayList<String>();
        }
        this.alternativeNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToAlternativeNames(String ... items) {
        if (this.alternativeNames == null) {
            this.alternativeNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.alternativeNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAlternativeNames(Collection<String> items) {
        if (this.alternativeNames == null) {
            this.alternativeNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.alternativeNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAlternativeNames(String ... items) {
        if (this.alternativeNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.alternativeNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAlternativeNames(Collection<String> items) {
        if (this.alternativeNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.alternativeNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAlternativeNames() {
        return this.alternativeNames;
    }

    public String getAlternativeName(int index) {
        return this.alternativeNames.get(index);
    }

    public String getFirstAlternativeName() {
        return this.alternativeNames.get(0);
    }

    public String getLastAlternativeName() {
        return this.alternativeNames.get(this.alternativeNames.size() - 1);
    }

    public String getMatchingAlternativeName(Predicate<String> predicate) {
        for (String item : this.alternativeNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAlternativeName(Predicate<String> predicate) {
        for (String item : this.alternativeNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAlternativeNames(List<String> alternativeNames) {
        if (alternativeNames != null) {
            this.alternativeNames = new ArrayList<String>();
            for (String item : alternativeNames) {
                this.addToAlternativeNames(item);
            }
        } else {
            this.alternativeNames = null;
        }
        return (A)((Object)this);
    }

    public A withAlternativeNames(String ... alternativeNames) {
        if (this.alternativeNames != null) {
            this.alternativeNames.clear();
            this._visitables.remove((Object)"alternativeNames");
        }
        if (alternativeNames != null) {
            for (String item : alternativeNames) {
                this.addToAlternativeNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAlternativeNames() {
        return this.alternativeNames != null && !this.alternativeNames.isEmpty();
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)((Object)this);
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public Integer getNodePort() {
        return this.nodePort;
    }

    public A withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (A)((Object)this);
    }

    public boolean hasNodePort() {
        return this.nodePort != null;
    }

    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public A withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return (A)((Object)this);
    }

    public boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericKafkaListenerConfigurationBootstrapFluent that = (GenericKafkaListenerConfigurationBootstrapFluent)((Object)o);
        if (!Objects.equals(this.alternativeNames, that.alternativeNames)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.nodePort, that.nodePort)) {
            return false;
        }
        return Objects.equals(this.loadBalancerIP, that.loadBalancerIP);
    }

    public int hashCode() {
        return Objects.hash(this.alternativeNames, this.host, this.annotations, this.labels, this.nodePort, this.loadBalancerIP, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alternativeNames != null && !this.alternativeNames.isEmpty()) {
            sb.append("alternativeNames:");
            sb.append(this.alternativeNames + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.nodePort != null) {
            sb.append("nodePort:");
            sb.append(this.nodePort + ",");
        }
        if (this.loadBalancerIP != null) {
            sb.append("loadBalancerIP:");
            sb.append(this.loadBalancerIP);
        }
        sb.append("}");
        return sb.toString();
    }
}

