/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.mirrormaker;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.common.HasConfigurableLogging;
import io.strimzi.api.kafka.model.common.HasConfigurableMetrics;
import io.strimzi.api.kafka.model.common.HasLivenessProbe;
import io.strimzi.api.kafka.model.common.HasReadinessProbe;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.Spec;
import io.strimzi.api.kafka.model.common.metrics.MetricsConfig;
import io.strimzi.api.kafka.model.common.tracing.Tracing;
import io.strimzi.api.kafka.model.mirrormaker.KafkaMirrorMakerConsumerSpec;
import io.strimzi.api.kafka.model.mirrormaker.KafkaMirrorMakerProducerSpec;
import io.strimzi.api.kafka.model.mirrormaker.KafkaMirrorMakerTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.OneOf;
import io.strimzi.crdgenerator.annotations.PresentInVersions;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "replicas", "image", "consumer", "producer", "resources", "whitelist", "include", "jvmOptions", "logging", "metricsConfig", "tracing", "template"})
@OneOf(value={@OneOf.Alternative(value={@OneOf.Alternative.Property(value="include")}), @OneOf.Alternative(value={@OneOf.Alternative.Property(value="whitelist")})})
public class KafkaMirrorMakerSpec
extends Spec
implements HasConfigurableMetrics,
HasConfigurableLogging,
HasLivenessProbe,
HasReadinessProbe {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_REPLICAS = 3;
    private int replicas = 3;
    private String version;
    private String image;
    private String whitelist;
    private String include;
    private KafkaMirrorMakerConsumerSpec consumer;
    private KafkaMirrorMakerProducerSpec producer;
    private ResourceRequirements resources;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private JvmOptions jvmOptions;
    private Logging logging;
    private MetricsConfig metricsConfig;
    private Tracing tracing;
    private KafkaMirrorMakerTemplate template;

    @Description(value="The number of pods in the `Deployment`.")
    @Minimum(value=0)
    @JsonProperty(required=true)
    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    @Description(value="The Kafka MirrorMaker version. Defaults to the latest version. Consult the documentation to understand the process required to upgrade or downgrade the version.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Description(value="The container image used for Kafka MirrorMaker pods. If no image name is explicitly specified, it is determined based on the `spec.version` configuration. The image names are specifically mapped to corresponding versions in the Cluster Operator configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Description(value="List of topics which are included for mirroring. This option allows any regular expression using Java-style regular expressions. Mirroring two topics named A and B is achieved by using the expression `A|B`. Or, as a special case, you can mirror all topics using the regular expression `*`. You can also specify multiple regular expressions separated by commas.")
    @DeprecatedProperty(movedToPath="spec.include")
    @PresentInVersions(value="v1alpha1-v1beta2")
    @Deprecated
    public String getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(String whitelist) {
        this.whitelist = whitelist;
    }

    @Description(value="List of topics which are included for mirroring. This option allows any regular expression using Java-style regular expressions. Mirroring two topics named A and B is achieved by using the expression `A|B`. Or, as a special case, you can mirror all topics using the regular expression `*`. You can also specify multiple regular expressions separated by commas.")
    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    @Description(value="Configuration of source cluster.")
    @JsonProperty(required=true)
    public KafkaMirrorMakerConsumerSpec getConsumer() {
        return this.consumer;
    }

    public void setConsumer(KafkaMirrorMakerConsumerSpec consumer) {
        this.consumer = consumer;
    }

    @Description(value="Configuration of target cluster.")
    @JsonProperty(required=true)
    public KafkaMirrorMakerProducerSpec getProducer() {
        return this.producer;
    }

    public void setProducer(KafkaMirrorMakerProducerSpec producer) {
        this.producer = producer;
    }

    @Override
    @Description(value="Metrics configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public void setMetricsConfig(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The configuration of tracing in Kafka MirrorMaker.")
    public Tracing getTracing() {
        return this.tracing;
    }

    public void setTracing(Tracing tracing) {
        this.tracing = tracing;
    }

    @Override
    @Description(value="Logging configuration for MirrorMaker.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Logging getLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JVM Options for pods")
    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(JvmOptions jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @KubeLink(group="core", version="v1", kind="resourcerequirements")
    @Description(value="CPU and memory resources to reserve.")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod liveness checking.")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    @Override
    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @Description(value="Pod readiness checking.")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    @Override
    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @Description(value="Template to specify how Kafka MirrorMaker resources, `Deployments` and `Pods`, are generated.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public KafkaMirrorMakerTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(KafkaMirrorMakerTemplate template) {
        this.template = template;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaMirrorMakerSpec)) {
            return false;
        }
        KafkaMirrorMakerSpec other = (KafkaMirrorMakerSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$whitelist = this.getWhitelist();
        String other$whitelist = other.getWhitelist();
        if (this$whitelist == null ? other$whitelist != null : !this$whitelist.equals(other$whitelist)) {
            return false;
        }
        String this$include = this.getInclude();
        String other$include = other.getInclude();
        if (this$include == null ? other$include != null : !this$include.equals(other$include)) {
            return false;
        }
        KafkaMirrorMakerConsumerSpec this$consumer = this.getConsumer();
        KafkaMirrorMakerConsumerSpec other$consumer = other.getConsumer();
        if (this$consumer == null ? other$consumer != null : !((Object)this$consumer).equals(other$consumer)) {
            return false;
        }
        KafkaMirrorMakerProducerSpec this$producer = this.getProducer();
        KafkaMirrorMakerProducerSpec other$producer = other.getProducer();
        if (this$producer == null ? other$producer != null : !((Object)this$producer).equals(other$producer)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        Probe this$livenessProbe = this.getLivenessProbe();
        Probe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.getReadinessProbe();
        Probe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        JvmOptions this$jvmOptions = this.getJvmOptions();
        JvmOptions other$jvmOptions = other.getJvmOptions();
        if (this$jvmOptions == null ? other$jvmOptions != null : !((Object)this$jvmOptions).equals(other$jvmOptions)) {
            return false;
        }
        Logging this$logging = this.getLogging();
        Logging other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !((Object)this$logging).equals(other$logging)) {
            return false;
        }
        MetricsConfig this$metricsConfig = this.getMetricsConfig();
        MetricsConfig other$metricsConfig = other.getMetricsConfig();
        if (this$metricsConfig == null ? other$metricsConfig != null : !((Object)this$metricsConfig).equals(other$metricsConfig)) {
            return false;
        }
        Tracing this$tracing = this.getTracing();
        Tracing other$tracing = other.getTracing();
        if (this$tracing == null ? other$tracing != null : !((Object)this$tracing).equals(other$tracing)) {
            return false;
        }
        KafkaMirrorMakerTemplate this$template = this.getTemplate();
        KafkaMirrorMakerTemplate other$template = other.getTemplate();
        return !(this$template == null ? other$template != null : !((Object)this$template).equals(other$template));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaMirrorMakerSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReplicas();
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $whitelist = this.getWhitelist();
        result = result * 59 + ($whitelist == null ? 43 : $whitelist.hashCode());
        String $include = this.getInclude();
        result = result * 59 + ($include == null ? 43 : $include.hashCode());
        KafkaMirrorMakerConsumerSpec $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : ((Object)$consumer).hashCode());
        KafkaMirrorMakerProducerSpec $producer = this.getProducer();
        result = result * 59 + ($producer == null ? 43 : ((Object)$producer).hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        Probe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        JvmOptions $jvmOptions = this.getJvmOptions();
        result = result * 59 + ($jvmOptions == null ? 43 : ((Object)$jvmOptions).hashCode());
        Logging $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : ((Object)$logging).hashCode());
        MetricsConfig $metricsConfig = this.getMetricsConfig();
        result = result * 59 + ($metricsConfig == null ? 43 : ((Object)$metricsConfig).hashCode());
        Tracing $tracing = this.getTracing();
        result = result * 59 + ($tracing == null ? 43 : ((Object)$tracing).hashCode());
        KafkaMirrorMakerTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        return result;
    }
}

