/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.mirrormaker2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.ClientTls;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.Pattern;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"alias", "bootstrapServers", "tls", "authentication", "config"})
public class KafkaMirrorMaker2ClusterSpec
implements UnknownPropertyPreserving,
Serializable {
    public static final String FORBIDDEN_PREFIXES = "ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers, consumer.interceptor.classes, producer.interceptor.classes";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols";
    private static final long serialVersionUID = 1L;
    private String alias;
    private String bootstrapServers;
    protected Map<String, Object> config = new HashMap<String, Object>(0);
    private ClientTls tls;
    private KafkaClientAuthentication authentication;
    private Map<String, Object> additionalProperties;

    @Description(value="Alias used to reference the Kafka cluster.")
    @JsonProperty(required=true)
    @Pattern(value="^[a-zA-Z0-9\\._\\-]{1,100}$")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Description(value="Authentication configuration for connecting to the cluster.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaClientAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(KafkaClientAuthentication authentication) {
        this.authentication = authentication;
    }

    @Description(value="The MirrorMaker 2 cluster config. Properties with the following prefixes cannot be set: ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers, consumer.interceptor.classes, producer.interceptor.classes (with the exception of: ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols).")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="TLS configuration for connecting MirrorMaker 2 connectors to a cluster.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ClientTls getTls() {
        return this.tls;
    }

    public void setTls(ClientTls tls) {
        this.tls = tls;
    }

    @Description(value="A comma-separated list of `host:port` pairs for establishing the connection to the Kafka cluster.")
    @JsonProperty(required=true)
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaMirrorMaker2ClusterSpec)) {
            return false;
        }
        KafkaMirrorMaker2ClusterSpec other = (KafkaMirrorMaker2ClusterSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        Map<String, Object> this$config = this.getConfig();
        Map<String, Object> other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        ClientTls this$tls = this.getTls();
        ClientTls other$tls = other.getTls();
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        KafkaClientAuthentication this$authentication = this.getAuthentication();
        KafkaClientAuthentication other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaMirrorMaker2ClusterSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        Map<String, Object> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        ClientTls $tls = this.getTls();
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        KafkaClientAuthentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

