/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.nodepool;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.Spec;
import io.strimzi.api.kafka.model.kafka.Storage;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolTemplate;
import io.strimzi.api.kafka.model.nodepool.ProcessRoles;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"replicas", "storage", "roles", "resources", "jvmOptions", "template"})
public class KafkaNodePoolSpec
extends Spec {
    private static final long serialVersionUID = 1L;
    private int replicas;
    private Storage storage;
    private List<ProcessRoles> roles;
    private ResourceRequirements resources;
    private JvmOptions jvmOptions;
    private KafkaNodePoolTemplate template;

    @Description(value="The number of pods in the pool.")
    @Minimum(value=0)
    @JsonProperty(required=true)
    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    @Description(value="Storage configuration (disk). Cannot be updated.")
    @JsonProperty(required=true)
    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    @Description(value="The roles that the nodes in this pool will have when KRaft mode is enabled. Supported values are 'broker' and 'controller'. This field is required. When KRaft mode is disabled, the only allowed value if `broker`.")
    @JsonProperty(required=true)
    public List<ProcessRoles> getRoles() {
        return this.roles;
    }

    public void setRoles(List<ProcessRoles> roles) {
        this.roles = roles;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @KubeLink(group="core", version="v1", kind="resourcerequirements")
    @Description(value="CPU and memory resources to reserve.")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JVM Options for pods")
    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(JvmOptions jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    @Description(value="Template for pool resources. The template allows users to specify how the resources belonging to this pool are generated.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public KafkaNodePoolTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(KafkaNodePoolTemplate template) {
        this.template = template;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaNodePoolSpec)) {
            return false;
        }
        KafkaNodePoolSpec other = (KafkaNodePoolSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        Storage this$storage = this.getStorage();
        Storage other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        List<ProcessRoles> this$roles = this.getRoles();
        List<ProcessRoles> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        JvmOptions this$jvmOptions = this.getJvmOptions();
        JvmOptions other$jvmOptions = other.getJvmOptions();
        if (this$jvmOptions == null ? other$jvmOptions != null : !((Object)this$jvmOptions).equals(other$jvmOptions)) {
            return false;
        }
        KafkaNodePoolTemplate this$template = this.getTemplate();
        KafkaNodePoolTemplate other$template = other.getTemplate();
        return !(this$template == null ? other$template != null : !((Object)this$template).equals(other$template));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaNodePoolSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getReplicas();
        Storage $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        List<ProcessRoles> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        JvmOptions $jvmOptions = this.getJvmOptions();
        result = result * 59 + ($jvmOptions == null ? 43 : ((Object)$jvmOptions).hashCode());
        KafkaNodePoolTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        return result;
    }
}

