/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.rebalance;

import io.strimzi.api.kafka.model.kafka.StatusFluent;
import io.strimzi.api.kafka.model.rebalance.KafkaRebalanceStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class KafkaRebalanceStatusFluent<A extends KafkaRebalanceStatusFluent<A>>
extends StatusFluent<A> {
    private String sessionId;
    private Map<String, Object> optimizationResult;

    public KafkaRebalanceStatusFluent() {
    }

    public KafkaRebalanceStatusFluent(KafkaRebalanceStatus instance) {
        KafkaRebalanceStatus kafkaRebalanceStatus = instance = instance != null ? instance : new KafkaRebalanceStatus();
        if (instance != null) {
            this.withSessionId(instance.getSessionId());
            this.withOptimizationResult(instance.getOptimizationResult());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public A withSessionId(String sessionId) {
        this.sessionId = sessionId;
        return (A)((Object)this);
    }

    public boolean hasSessionId() {
        return this.sessionId != null;
    }

    public A addToOptimizationResult(String key, Object value) {
        if (this.optimizationResult == null && key != null && value != null) {
            this.optimizationResult = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.optimizationResult.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToOptimizationResult(Map<String, Object> map) {
        if (this.optimizationResult == null && map != null) {
            this.optimizationResult = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.optimizationResult.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromOptimizationResult(String key) {
        if (this.optimizationResult == null) {
            return (A)((Object)this);
        }
        if (key != null && this.optimizationResult != null) {
            this.optimizationResult.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromOptimizationResult(Map<String, Object> map) {
        if (this.optimizationResult == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.optimizationResult == null) continue;
                this.optimizationResult.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getOptimizationResult() {
        return this.optimizationResult;
    }

    public <K, V> A withOptimizationResult(Map<String, Object> optimizationResult) {
        this.optimizationResult = optimizationResult == null ? null : new LinkedHashMap<String, Object>(optimizationResult);
        return (A)((Object)this);
    }

    public boolean hasOptimizationResult() {
        return this.optimizationResult != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaRebalanceStatusFluent that = (KafkaRebalanceStatusFluent)((Object)o);
        if (!Objects.equals(this.sessionId, that.sessionId)) {
            return false;
        }
        return Objects.equals(this.optimizationResult, that.optimizationResult);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sessionId, this.optimizationResult, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sessionId != null) {
            sb.append("sessionId:");
            sb.append(this.sessionId + ",");
        }
        if (this.optimizationResult != null && !this.optimizationResult.isEmpty()) {
            sb.append("optimizationResult:");
            sb.append(this.optimizationResult);
        }
        sb.append("}");
        return sb.toString();
    }
}

