/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.user.KafkaUserAuthorizationSimple;
import io.strimzi.api.kafka.model.user.acl.AclRule;
import io.strimzi.api.kafka.model.user.acl.AclRuleBuilder;
import io.strimzi.api.kafka.model.user.acl.AclRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaUserAuthorizationSimpleFluent<A extends KafkaUserAuthorizationSimpleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<AclRuleBuilder> acls;

    public KafkaUserAuthorizationSimpleFluent() {
    }

    public KafkaUserAuthorizationSimpleFluent(KafkaUserAuthorizationSimple instance) {
        KafkaUserAuthorizationSimple kafkaUserAuthorizationSimple = instance = instance != null ? instance : new KafkaUserAuthorizationSimple();
        if (instance != null) {
            this.withAcls(instance.getAcls());
        }
    }

    public A addToAcls(int index, AclRule item) {
        if (this.acls == null) {
            this.acls = new ArrayList();
        }
        AclRuleBuilder builder = new AclRuleBuilder(item);
        if (index < 0 || index >= this.acls.size()) {
            this._visitables.get((Object)"acls").add(builder);
            this.acls.add(builder);
        } else {
            this._visitables.get((Object)"acls").add(index, builder);
            this.acls.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAcls(int index, AclRule item) {
        if (this.acls == null) {
            this.acls = new ArrayList();
        }
        AclRuleBuilder builder = new AclRuleBuilder(item);
        if (index < 0 || index >= this.acls.size()) {
            this._visitables.get((Object)"acls").add(builder);
            this.acls.add(builder);
        } else {
            this._visitables.get((Object)"acls").set(index, builder);
            this.acls.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAcls(AclRule ... items) {
        if (this.acls == null) {
            this.acls = new ArrayList();
        }
        for (AclRule item : items) {
            AclRuleBuilder builder = new AclRuleBuilder(item);
            this._visitables.get((Object)"acls").add(builder);
            this.acls.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAcls(Collection<AclRule> items) {
        if (this.acls == null) {
            this.acls = new ArrayList();
        }
        for (AclRule item : items) {
            AclRuleBuilder builder = new AclRuleBuilder(item);
            this._visitables.get((Object)"acls").add(builder);
            this.acls.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAcls(AclRule ... items) {
        if (this.acls == null) {
            return (A)((Object)this);
        }
        for (AclRule item : items) {
            AclRuleBuilder builder = new AclRuleBuilder(item);
            this._visitables.get((Object)"acls").remove((Object)builder);
            this.acls.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAcls(Collection<AclRule> items) {
        if (this.acls == null) {
            return (A)((Object)this);
        }
        for (AclRule item : items) {
            AclRuleBuilder builder = new AclRuleBuilder(item);
            this._visitables.get((Object)"acls").remove((Object)builder);
            this.acls.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAcls(Predicate<AclRuleBuilder> predicate) {
        if (this.acls == null) {
            return (A)((Object)this);
        }
        Iterator<AclRuleBuilder> each = this.acls.iterator();
        List visitables = this._visitables.get((Object)"acls");
        while (each.hasNext()) {
            AclRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AclRule> buildAcls() {
        return this.acls != null ? KafkaUserAuthorizationSimpleFluent.build(this.acls) : null;
    }

    public AclRule buildAcl(int index) {
        return this.acls.get(index).build();
    }

    public AclRule buildFirstAcl() {
        return this.acls.get(0).build();
    }

    public AclRule buildLastAcl() {
        return this.acls.get(this.acls.size() - 1).build();
    }

    public AclRule buildMatchingAcl(Predicate<AclRuleBuilder> predicate) {
        for (AclRuleBuilder item : this.acls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAcl(Predicate<AclRuleBuilder> predicate) {
        for (AclRuleBuilder item : this.acls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAcls(List<AclRule> acls) {
        if (this.acls != null) {
            this._visitables.get((Object)"acls").clear();
        }
        if (acls != null) {
            this.acls = new ArrayList();
            for (AclRule item : acls) {
                this.addToAcls(item);
            }
        } else {
            this.acls = null;
        }
        return (A)((Object)this);
    }

    public A withAcls(AclRule ... acls) {
        if (this.acls != null) {
            this.acls.clear();
            this._visitables.remove((Object)"acls");
        }
        if (acls != null) {
            for (AclRule item : acls) {
                this.addToAcls(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAcls() {
        return this.acls != null && !this.acls.isEmpty();
    }

    public AclsNested<A> addNewAcl() {
        return new AclsNested(-1, null);
    }

    public AclsNested<A> addNewAclLike(AclRule item) {
        return new AclsNested(-1, item);
    }

    public AclsNested<A> setNewAclLike(int index, AclRule item) {
        return new AclsNested(index, item);
    }

    public AclsNested<A> editAcl(int index) {
        if (this.acls.size() <= index) {
            throw new RuntimeException("Can't edit acls. Index exceeds size.");
        }
        return this.setNewAclLike(index, this.buildAcl(index));
    }

    public AclsNested<A> editFirstAcl() {
        if (this.acls.size() == 0) {
            throw new RuntimeException("Can't edit first acls. The list is empty.");
        }
        return this.setNewAclLike(0, this.buildAcl(0));
    }

    public AclsNested<A> editLastAcl() {
        int index = this.acls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last acls. The list is empty.");
        }
        return this.setNewAclLike(index, this.buildAcl(index));
    }

    public AclsNested<A> editMatchingAcl(Predicate<AclRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.acls.size(); ++i) {
            if (!predicate.test(this.acls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching acls. No match found.");
        }
        return this.setNewAclLike(index, this.buildAcl(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaUserAuthorizationSimpleFluent that = (KafkaUserAuthorizationSimpleFluent)((Object)o);
        return Objects.equals(this.acls, that.acls);
    }

    public int hashCode() {
        return Objects.hash(this.acls, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acls != null && !this.acls.isEmpty()) {
            sb.append("acls:");
            sb.append(this.acls);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AclsNested<N>
    extends AclRuleFluent<AclsNested<N>>
    implements Nested<N> {
        AclRuleBuilder builder;
        int index;

        AclsNested(int index, AclRule item) {
            this.index = index;
            this.builder = new AclRuleBuilder(this, item);
        }

        public N and() {
            return (N)KafkaUserAuthorizationSimpleFluent.this.setToAcls(this.index, this.builder.build());
        }

        public N endAcl() {
            return this.and();
        }
    }
}

