package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBridgeConsumerSpecBuilder extends KafkaBridgeConsumerSpecFluent<KafkaBridgeConsumerSpecBuilder> implements VisitableBuilder<KafkaBridgeConsumerSpec,KafkaBridgeConsumerSpecBuilder>{
  public KafkaBridgeConsumerSpecBuilder() {
    this(false);
  }
  public KafkaBridgeConsumerSpecBuilder(Boolean validationEnabled) {
    this(new KafkaBridgeConsumerSpec(), validationEnabled);
  }
  public KafkaBridgeConsumerSpecBuilder(KafkaBridgeConsumerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBridgeConsumerSpecBuilder(KafkaBridgeConsumerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBridgeConsumerSpec(), validationEnabled);
  }
  public KafkaBridgeConsumerSpecBuilder(KafkaBridgeConsumerSpecFluent<?> fluent,KafkaBridgeConsumerSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaBridgeConsumerSpecBuilder(KafkaBridgeConsumerSpecFluent<?> fluent,KafkaBridgeConsumerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaBridgeConsumerSpec());

    if (instance != null) {
      fluent.withConfig(instance.getConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBridgeConsumerSpecBuilder(KafkaBridgeConsumerSpec instance) {
    this(instance,false);
  }
  public KafkaBridgeConsumerSpecBuilder(KafkaBridgeConsumerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaBridgeConsumerSpec());

    if (instance != null) {
      this.withConfig(instance.getConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaBridgeConsumerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBridgeConsumerSpec build() {
    KafkaBridgeConsumerSpec buildable = new KafkaBridgeConsumerSpec();
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  
}