package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBridgeHttpCorsBuilder extends KafkaBridgeHttpCorsFluent<KafkaBridgeHttpCorsBuilder> implements VisitableBuilder<KafkaBridgeHttpCors,KafkaBridgeHttpCorsBuilder>{
  public KafkaBridgeHttpCorsBuilder() {
    this(false);
  }
  public KafkaBridgeHttpCorsBuilder(Boolean validationEnabled) {
    this(new KafkaBridgeHttpCors(), validationEnabled);
  }
  public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCorsFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCorsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBridgeHttpCors(), validationEnabled);
  }
  public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCorsFluent<?> fluent,KafkaBridgeHttpCors instance) {
    this(fluent, instance, false);
  }
  public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCorsFluent<?> fluent,KafkaBridgeHttpCors instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaBridgeHttpCors());

    if (instance != null) {
      fluent.withAllowedOrigins(instance.getAllowedOrigins());
      fluent.withAllowedMethods(instance.getAllowedMethods());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCors instance) {
    this(instance,false);
  }
  public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCors instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaBridgeHttpCors());

    if (instance != null) {
      this.withAllowedOrigins(instance.getAllowedOrigins());
      this.withAllowedMethods(instance.getAllowedMethods());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaBridgeHttpCorsFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBridgeHttpCors build() {
    KafkaBridgeHttpCors buildable = new KafkaBridgeHttpCors();
    buildable.setAllowedOrigins(fluent.getAllowedOrigins());
    buildable.setAllowedMethods(fluent.getAllowedMethods());
    return buildable;
  }
  
}