package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBridgeProducerSpecBuilder extends KafkaBridgeProducerSpecFluent<KafkaBridgeProducerSpecBuilder> implements VisitableBuilder<KafkaBridgeProducerSpec,KafkaBridgeProducerSpecBuilder>{
  public KafkaBridgeProducerSpecBuilder() {
    this(false);
  }
  public KafkaBridgeProducerSpecBuilder(Boolean validationEnabled) {
    this(new KafkaBridgeProducerSpec(), validationEnabled);
  }
  public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBridgeProducerSpec(), validationEnabled);
  }
  public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpecFluent<?> fluent,KafkaBridgeProducerSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpecFluent<?> fluent,KafkaBridgeProducerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaBridgeProducerSpec());

    if (instance != null) {
      fluent.withConfig(instance.getConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpec instance) {
    this(instance,false);
  }
  public KafkaBridgeProducerSpecBuilder(KafkaBridgeProducerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaBridgeProducerSpec());

    if (instance != null) {
      this.withConfig(instance.getConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaBridgeProducerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBridgeProducerSpec build() {
    KafkaBridgeProducerSpec buildable = new KafkaBridgeProducerSpec();
    buildable.setConfig(fluent.getConfig());
    return buildable;
  }
  
}