package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaBridgeSpecBuilder extends KafkaBridgeSpecFluent<KafkaBridgeSpecBuilder> implements VisitableBuilder<KafkaBridgeSpec,KafkaBridgeSpecBuilder>{
  public KafkaBridgeSpecBuilder() {
    this(false);
  }
  public KafkaBridgeSpecBuilder(Boolean validationEnabled) {
    this(new KafkaBridgeSpec(), validationEnabled);
  }
  public KafkaBridgeSpecBuilder(KafkaBridgeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaBridgeSpecBuilder(KafkaBridgeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaBridgeSpec(), validationEnabled);
  }
  public KafkaBridgeSpecBuilder(KafkaBridgeSpecFluent<?> fluent,KafkaBridgeSpec instance) {
    this(fluent, instance, false);
  }
  public KafkaBridgeSpecBuilder(KafkaBridgeSpecFluent<?> fluent,KafkaBridgeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaBridgeSpec());

    if (instance != null) {
      fluent.withReplicas(instance.getReplicas());
      fluent.withImage(instance.getImage());
      fluent.withHttp(instance.getHttp());
      fluent.withBootstrapServers(instance.getBootstrapServers());
      fluent.withTls(instance.getTls());
      fluent.withAuthentication(instance.getAuthentication());
      fluent.withConsumer(instance.getConsumer());
      fluent.withProducer(instance.getProducer());
      fluent.withAdminClient(instance.getAdminClient());
      fluent.withResources(instance.getResources());
      fluent.withJvmOptions(instance.getJvmOptions());
      fluent.withLogging(instance.getLogging());
      fluent.withEnableMetrics(instance.getEnableMetrics());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withTemplate(instance.getTemplate());
      fluent.withTracing(instance.getTracing());
      fluent.withClientRackInitImage(instance.getClientRackInitImage());
      fluent.withRack(instance.getRack());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaBridgeSpecBuilder(KafkaBridgeSpec instance) {
    this(instance,false);
  }
  public KafkaBridgeSpecBuilder(KafkaBridgeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaBridgeSpec());

    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withImage(instance.getImage());
      this.withHttp(instance.getHttp());
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withTls(instance.getTls());
      this.withAuthentication(instance.getAuthentication());
      this.withConsumer(instance.getConsumer());
      this.withProducer(instance.getProducer());
      this.withAdminClient(instance.getAdminClient());
      this.withResources(instance.getResources());
      this.withJvmOptions(instance.getJvmOptions());
      this.withLogging(instance.getLogging());
      this.withEnableMetrics(instance.getEnableMetrics());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withTemplate(instance.getTemplate());
      this.withTracing(instance.getTracing());
      this.withClientRackInitImage(instance.getClientRackInitImage());
      this.withRack(instance.getRack());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaBridgeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaBridgeSpec build() {
    KafkaBridgeSpec buildable = new KafkaBridgeSpec();
    buildable.setReplicas(fluent.getReplicas());
    buildable.setImage(fluent.getImage());
    buildable.setHttp(fluent.buildHttp());
    buildable.setBootstrapServers(fluent.getBootstrapServers());
    buildable.setTls(fluent.buildTls());
    buildable.setAuthentication(fluent.buildAuthentication());
    buildable.setConsumer(fluent.buildConsumer());
    buildable.setProducer(fluent.buildProducer());
    buildable.setAdminClient(fluent.buildAdminClient());
    buildable.setResources(fluent.getResources());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setLogging(fluent.buildLogging());
    buildable.setEnableMetrics(fluent.isEnableMetrics());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setTemplate(fluent.buildTemplate());
    buildable.setTracing(fluent.buildTracing());
    buildable.setClientRackInitImage(fluent.getClientRackInitImage());
    buildable.setRack(fluent.buildRack());
    return buildable;
  }
  
}