package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertAndKeySecretSourceBuilder extends CertAndKeySecretSourceFluent<CertAndKeySecretSourceBuilder> implements VisitableBuilder<CertAndKeySecretSource,CertAndKeySecretSourceBuilder>{
  public CertAndKeySecretSourceBuilder() {
    this(false);
  }
  public CertAndKeySecretSourceBuilder(Boolean validationEnabled) {
    this(new CertAndKeySecretSource(), validationEnabled);
  }
  public CertAndKeySecretSourceBuilder(CertAndKeySecretSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CertAndKeySecretSourceBuilder(CertAndKeySecretSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertAndKeySecretSource(), validationEnabled);
  }
  public CertAndKeySecretSourceBuilder(CertAndKeySecretSourceFluent<?> fluent,CertAndKeySecretSource instance) {
    this(fluent, instance, false);
  }
  public CertAndKeySecretSourceBuilder(CertAndKeySecretSourceFluent<?> fluent,CertAndKeySecretSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertAndKeySecretSource());

    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withSecretName(instance.getSecretName());
      fluent.withCertificate(instance.getCertificate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertAndKeySecretSourceBuilder(CertAndKeySecretSource instance) {
    this(instance,false);
  }
  public CertAndKeySecretSourceBuilder(CertAndKeySecretSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertAndKeySecretSource());

    if (instance != null) {
      this.withKey(instance.getKey());
      this.withSecretName(instance.getSecretName());
      this.withCertificate(instance.getCertificate());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertAndKeySecretSourceFluent<?> fluent;
  Boolean validationEnabled;
  public CertAndKeySecretSource build() {
    CertAndKeySecretSource buildable = new CertAndKeySecretSource();
    buildable.setKey(fluent.getKey());
    buildable.setSecretName(fluent.getSecretName());
    buildable.setCertificate(fluent.getCertificate());
    return buildable;
  }
  
}