package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClientTlsBuilder extends ClientTlsFluent<ClientTlsBuilder> implements VisitableBuilder<ClientTls,ClientTlsBuilder>{
  public ClientTlsBuilder() {
    this(false);
  }
  public ClientTlsBuilder(Boolean validationEnabled) {
    this(new ClientTls(), validationEnabled);
  }
  public ClientTlsBuilder(ClientTlsFluent<?> fluent) {
    this(fluent, false);
  }
  public ClientTlsBuilder(ClientTlsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClientTls(), validationEnabled);
  }
  public ClientTlsBuilder(ClientTlsFluent<?> fluent,ClientTls instance) {
    this(fluent, instance, false);
  }
  public ClientTlsBuilder(ClientTlsFluent<?> fluent,ClientTls instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClientTls());

    if (instance != null) {
      fluent.withTrustedCertificates(instance.getTrustedCertificates());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClientTlsBuilder(ClientTls instance) {
    this(instance,false);
  }
  public ClientTlsBuilder(ClientTls instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClientTls());

    if (instance != null) {
      this.withTrustedCertificates(instance.getTrustedCertificates());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClientTlsFluent<?> fluent;
  Boolean validationEnabled;
  public ClientTls build() {
    ClientTls buildable = new ClientTls();
    buildable.setTrustedCertificates(fluent.buildTrustedCertificates());
    return buildable;
  }
  
}