package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClientTlsFluent<A extends ClientTlsFluent<A>> extends BaseFluent<A>{
  public ClientTlsFluent() {
  }
  public ClientTlsFluent(ClientTls instance) {
    instance = (instance != null ? instance : new ClientTls());

    if (instance != null) {
      this.withTrustedCertificates(instance.getTrustedCertificates());
    }
  }
  private ArrayList<CertSecretSourceBuilder> trustedCertificates;
  public A addToTrustedCertificates(int index,CertSecretSource item) {
    if (this.trustedCertificates == null) {this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
    if (index < 0 || index >= trustedCertificates.size()) { _visitables.get("trustedCertificates").add(builder); trustedCertificates.add(builder); } else { _visitables.get("trustedCertificates").add(index, builder); trustedCertificates.add(index, builder);}
    return (A)this;
  }
  public A setToTrustedCertificates(int index,CertSecretSource item) {
    if (this.trustedCertificates == null) {this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
    if (index < 0 || index >= trustedCertificates.size()) { _visitables.get("trustedCertificates").add(builder); trustedCertificates.add(builder); } else { _visitables.get("trustedCertificates").set(index, builder); trustedCertificates.set(index, builder);}
    return (A)this;
  }
  public A addToTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... items) {
    if (this.trustedCertificates == null) {this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").add(builder);this.trustedCertificates.add(builder);} return (A)this;
  }
  public A addAllToTrustedCertificates(Collection<CertSecretSource> items) {
    if (this.trustedCertificates == null) {this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").add(builder);this.trustedCertificates.add(builder);} return (A)this;
  }
  public A removeFromTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... items) {
    if (this.trustedCertificates == null) return (A)this;
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").remove(builder); this.trustedCertificates.remove(builder);} return (A)this;
  }
  public A removeAllFromTrustedCertificates(Collection<CertSecretSource> items) {
    if (this.trustedCertificates == null) return (A)this;
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").remove(builder); this.trustedCertificates.remove(builder);} return (A)this;
  }
  public A removeMatchingFromTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
    if (trustedCertificates == null) return (A) this;
    final Iterator<CertSecretSourceBuilder> each = trustedCertificates.iterator();
    final List visitables = _visitables.get("trustedCertificates");
    while (each.hasNext()) {
      CertSecretSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<CertSecretSource> buildTrustedCertificates() {
    return trustedCertificates != null ? build(trustedCertificates) : null;
  }
  public CertSecretSource buildTrustedCertificate(int index) {
    return this.trustedCertificates.get(index).build();
  }
  public CertSecretSource buildFirstTrustedCertificate() {
    return this.trustedCertificates.get(0).build();
  }
  public CertSecretSource buildLastTrustedCertificate() {
    return this.trustedCertificates.get(trustedCertificates.size() - 1).build();
  }
  public CertSecretSource buildMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    for (CertSecretSourceBuilder item: trustedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    for (CertSecretSourceBuilder item: trustedCertificates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTrustedCertificates(List<CertSecretSource> trustedCertificates) {
    if (this.trustedCertificates != null) { _visitables.get("trustedCertificates").clear();}
    if (trustedCertificates != null) {this.trustedCertificates = new ArrayList(); for (CertSecretSource item : trustedCertificates){this.addToTrustedCertificates(item);}} else { this.trustedCertificates = null;} return (A) this;
  }
  public A withTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... trustedCertificates) {
    if (this.trustedCertificates != null) {this.trustedCertificates.clear(); _visitables.remove("trustedCertificates"); }
    if (trustedCertificates != null) {for (CertSecretSource item :trustedCertificates){ this.addToTrustedCertificates(item);}} return (A) this;
  }
  public boolean hasTrustedCertificates() {
    return trustedCertificates != null && !trustedCertificates.isEmpty();
  }
  public TrustedCertificatesNested<A> addNewTrustedCertificate() {
    return new TrustedCertificatesNested(-1, null);
  }
  public TrustedCertificatesNested<A> addNewTrustedCertificateLike(CertSecretSource item) {
    return new TrustedCertificatesNested(-1, item);
  }
  public TrustedCertificatesNested<A> setNewTrustedCertificateLike(int index,CertSecretSource item) {
    return new TrustedCertificatesNested(index, item);
  }
  public TrustedCertificatesNested<A> editTrustedCertificate(int index) {
    if (trustedCertificates.size() <= index) throw new RuntimeException("Can't edit trustedCertificates. Index exceeds size.");
    return setNewTrustedCertificateLike(index, buildTrustedCertificate(index));
  }
  public TrustedCertificatesNested<A> editFirstTrustedCertificate() {
    if (trustedCertificates.size() == 0) throw new RuntimeException("Can't edit first trustedCertificates. The list is empty.");
    return setNewTrustedCertificateLike(0, buildTrustedCertificate(0));
  }
  public TrustedCertificatesNested<A> editLastTrustedCertificate() {
    int index = trustedCertificates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last trustedCertificates. The list is empty.");
    return setNewTrustedCertificateLike(index, buildTrustedCertificate(index));
  }
  public TrustedCertificatesNested<A> editMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<trustedCertificates.size();i++) { 
    if (predicate.test(trustedCertificates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching trustedCertificates. No match found.");
    return setNewTrustedCertificateLike(index, buildTrustedCertificate(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClientTlsFluent that = (ClientTlsFluent) o;
    if (!java.util.Objects.equals(trustedCertificates, that.trustedCertificates)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(trustedCertificates,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (trustedCertificates != null && !trustedCertificates.isEmpty()) { sb.append("trustedCertificates:"); sb.append(trustedCertificates); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.common."+"CertAndKeySecretSource": return (VisitableBuilder<T, ?>)new io.strimzi.api.kafka.model.common.CertAndKeySecretSourceBuilder((io.strimzi.api.kafka.model.common.CertAndKeySecretSource) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class TrustedCertificatesNested<N> extends CertSecretSourceFluent<TrustedCertificatesNested<N>> implements Nested<N>{
    TrustedCertificatesNested(int index,CertSecretSource item) {
      this.index = index;
      this.builder = new CertSecretSourceBuilder(this, item);
    }
    CertSecretSourceBuilder builder;
    int index;
    public N and() {
      return (N) ClientTlsFluent.this.setToTrustedCertificates(index,builder.build());
    }
    public N endTrustedCertificate() {
      return and();
    }
    
  }
  
}