package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalConfigurationReferenceBuilder extends ExternalConfigurationReferenceFluent<ExternalConfigurationReferenceBuilder> implements VisitableBuilder<ExternalConfigurationReference,ExternalConfigurationReferenceBuilder>{
  public ExternalConfigurationReferenceBuilder() {
    this(false);
  }
  public ExternalConfigurationReferenceBuilder(Boolean validationEnabled) {
    this(new ExternalConfigurationReference(), validationEnabled);
  }
  public ExternalConfigurationReferenceBuilder(ExternalConfigurationReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalConfigurationReferenceBuilder(ExternalConfigurationReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalConfigurationReference(), validationEnabled);
  }
  public ExternalConfigurationReferenceBuilder(ExternalConfigurationReferenceFluent<?> fluent,ExternalConfigurationReference instance) {
    this(fluent, instance, false);
  }
  public ExternalConfigurationReferenceBuilder(ExternalConfigurationReferenceFluent<?> fluent,ExternalConfigurationReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExternalConfigurationReference());

    if (instance != null) {
      fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalConfigurationReferenceBuilder(ExternalConfigurationReference instance) {
    this(instance,false);
  }
  public ExternalConfigurationReferenceBuilder(ExternalConfigurationReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExternalConfigurationReference());

    if (instance != null) {
      this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalConfigurationReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalConfigurationReference build() {
    ExternalConfigurationReference buildable = new ExternalConfigurationReference();
    buildable.setConfigMapKeyRef(fluent.getConfigMapKeyRef());
    return buildable;
  }
  
}