package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalLoggingBuilder extends ExternalLoggingFluent<ExternalLoggingBuilder> implements VisitableBuilder<ExternalLogging,ExternalLoggingBuilder>{
  public ExternalLoggingBuilder() {
    this(false);
  }
  public ExternalLoggingBuilder(Boolean validationEnabled) {
    this(new ExternalLogging(), validationEnabled);
  }
  public ExternalLoggingBuilder(ExternalLoggingFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalLoggingBuilder(ExternalLoggingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalLogging(), validationEnabled);
  }
  public ExternalLoggingBuilder(ExternalLoggingFluent<?> fluent,ExternalLogging instance) {
    this(fluent, instance, false);
  }
  public ExternalLoggingBuilder(ExternalLoggingFluent<?> fluent,ExternalLogging instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExternalLogging());

    if (instance != null) {
      fluent.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalLoggingBuilder(ExternalLogging instance) {
    this(instance,false);
  }
  public ExternalLoggingBuilder(ExternalLogging instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExternalLogging());

    if (instance != null) {
      this.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalLoggingFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalLogging build() {
    ExternalLogging buildable = new ExternalLogging();
    buildable.setValueFrom(fluent.buildValueFrom());
    return buildable;
  }
  
}