package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GenericSecretSourceBuilder extends GenericSecretSourceFluent<GenericSecretSourceBuilder> implements VisitableBuilder<GenericSecretSource,GenericSecretSourceBuilder>{
  public GenericSecretSourceBuilder() {
    this(false);
  }
  public GenericSecretSourceBuilder(Boolean validationEnabled) {
    this(new GenericSecretSource(), validationEnabled);
  }
  public GenericSecretSourceBuilder(GenericSecretSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GenericSecretSourceBuilder(GenericSecretSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GenericSecretSource(), validationEnabled);
  }
  public GenericSecretSourceBuilder(GenericSecretSourceFluent<?> fluent,GenericSecretSource instance) {
    this(fluent, instance, false);
  }
  public GenericSecretSourceBuilder(GenericSecretSourceFluent<?> fluent,GenericSecretSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GenericSecretSource());

    if (instance != null) {
      fluent.withSecretName(instance.getSecretName());
      fluent.withKey(instance.getKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GenericSecretSourceBuilder(GenericSecretSource instance) {
    this(instance,false);
  }
  public GenericSecretSourceBuilder(GenericSecretSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GenericSecretSource());

    if (instance != null) {
      this.withSecretName(instance.getSecretName());
      this.withKey(instance.getKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  GenericSecretSourceFluent<?> fluent;
  Boolean validationEnabled;
  public GenericSecretSource build() {
    GenericSecretSource buildable = new GenericSecretSource();
    buildable.setSecretName(fluent.getSecretName());
    buildable.setKey(fluent.getKey());
    return buildable;
  }
  
}