package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InlineLoggingBuilder extends InlineLoggingFluent<InlineLoggingBuilder> implements VisitableBuilder<InlineLogging,InlineLoggingBuilder>{
  public InlineLoggingBuilder() {
    this(false);
  }
  public InlineLoggingBuilder(Boolean validationEnabled) {
    this(new InlineLogging(), validationEnabled);
  }
  public InlineLoggingBuilder(InlineLoggingFluent<?> fluent) {
    this(fluent, false);
  }
  public InlineLoggingBuilder(InlineLoggingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InlineLogging(), validationEnabled);
  }
  public InlineLoggingBuilder(InlineLoggingFluent<?> fluent,InlineLogging instance) {
    this(fluent, instance, false);
  }
  public InlineLoggingBuilder(InlineLoggingFluent<?> fluent,InlineLogging instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new InlineLogging());

    if (instance != null) {
      fluent.withLoggers(instance.getLoggers());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InlineLoggingBuilder(InlineLogging instance) {
    this(instance,false);
  }
  public InlineLoggingBuilder(InlineLogging instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new InlineLogging());

    if (instance != null) {
      this.withLoggers(instance.getLoggers());
    }
    this.validationEnabled = validationEnabled; 
  }
  InlineLoggingFluent<?> fluent;
  Boolean validationEnabled;
  public InlineLogging build() {
    InlineLogging buildable = new InlineLogging();
    buildable.setLoggers(fluent.getLoggers());
    return buildable;
  }
  
}