package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JvmOptionsBuilder extends JvmOptionsFluent<JvmOptionsBuilder> implements VisitableBuilder<JvmOptions,JvmOptionsBuilder>{
  public JvmOptionsBuilder() {
    this(false);
  }
  public JvmOptionsBuilder(Boolean validationEnabled) {
    this(new JvmOptions(), validationEnabled);
  }
  public JvmOptionsBuilder(JvmOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public JvmOptionsBuilder(JvmOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JvmOptions(), validationEnabled);
  }
  public JvmOptionsBuilder(JvmOptionsFluent<?> fluent,JvmOptions instance) {
    this(fluent, instance, false);
  }
  public JvmOptionsBuilder(JvmOptionsFluent<?> fluent,JvmOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new JvmOptions());

    if (instance != null) {
      fluent.withXmx(instance.getXmx());
      fluent.withXms(instance.getXms());
      fluent.withGcLoggingEnabled(instance.isGcLoggingEnabled());
      fluent.withJavaSystemProperties(instance.getJavaSystemProperties());
      fluent.withXx(instance.getXx());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JvmOptionsBuilder(JvmOptions instance) {
    this(instance,false);
  }
  public JvmOptionsBuilder(JvmOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new JvmOptions());

    if (instance != null) {
      this.withXmx(instance.getXmx());
      this.withXms(instance.getXms());
      this.withGcLoggingEnabled(instance.isGcLoggingEnabled());
      this.withJavaSystemProperties(instance.getJavaSystemProperties());
      this.withXx(instance.getXx());
    }
    this.validationEnabled = validationEnabled; 
  }
  JvmOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public JvmOptions build() {
    JvmOptions buildable = new JvmOptions();
    buildable.setXmx(fluent.getXmx());
    buildable.setXms(fluent.getXms());
    buildable.setGcLoggingEnabled(fluent.isGcLoggingEnabled());
    buildable.setJavaSystemProperties(fluent.buildJavaSystemProperties());
    buildable.setXx(fluent.getXx());
    return buildable;
  }
  
}