package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JvmOptionsFluent<A extends JvmOptionsFluent<A>> extends BaseFluent<A>{
  public JvmOptionsFluent() {
  }
  public JvmOptionsFluent(JvmOptions instance) {
    instance = (instance != null ? instance : new JvmOptions());

    if (instance != null) {
      this.withXmx(instance.getXmx());
      this.withXms(instance.getXms());
      this.withGcLoggingEnabled(instance.isGcLoggingEnabled());
      this.withJavaSystemProperties(instance.getJavaSystemProperties());
      this.withXx(instance.getXx());
    }
  }
  private String xmx;
  private String xms;
  private boolean gcLoggingEnabled;
  private ArrayList<SystemPropertyBuilder> javaSystemProperties;
  private Map<String,String> xx;
  public String getXmx() {
    return this.xmx;
  }
  public A withXmx(String xmx) {
    this.xmx=xmx; return (A) this;
  }
  public boolean hasXmx() {
    return this.xmx != null;
  }
  public String getXms() {
    return this.xms;
  }
  public A withXms(String xms) {
    this.xms=xms; return (A) this;
  }
  public boolean hasXms() {
    return this.xms != null;
  }
  public boolean isGcLoggingEnabled() {
    return this.gcLoggingEnabled;
  }
  public A withGcLoggingEnabled(boolean gcLoggingEnabled) {
    this.gcLoggingEnabled=gcLoggingEnabled; return (A) this;
  }
  public boolean hasGcLoggingEnabled() {
    return true;
  }
  public A addToJavaSystemProperties(int index,SystemProperty item) {
    if (this.javaSystemProperties == null) {this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();}
    SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
    if (index < 0 || index >= javaSystemProperties.size()) { _visitables.get("javaSystemProperties").add(builder); javaSystemProperties.add(builder); } else { _visitables.get("javaSystemProperties").add(index, builder); javaSystemProperties.add(index, builder);}
    return (A)this;
  }
  public A setToJavaSystemProperties(int index,SystemProperty item) {
    if (this.javaSystemProperties == null) {this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();}
    SystemPropertyBuilder builder = new SystemPropertyBuilder(item);
    if (index < 0 || index >= javaSystemProperties.size()) { _visitables.get("javaSystemProperties").add(builder); javaSystemProperties.add(builder); } else { _visitables.get("javaSystemProperties").set(index, builder); javaSystemProperties.set(index, builder);}
    return (A)this;
  }
  public A addToJavaSystemProperties(io.strimzi.api.kafka.model.common.SystemProperty... items) {
    if (this.javaSystemProperties == null) {this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();}
    for (SystemProperty item : items) {SystemPropertyBuilder builder = new SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").add(builder);this.javaSystemProperties.add(builder);} return (A)this;
  }
  public A addAllToJavaSystemProperties(Collection<SystemProperty> items) {
    if (this.javaSystemProperties == null) {this.javaSystemProperties = new ArrayList<SystemPropertyBuilder>();}
    for (SystemProperty item : items) {SystemPropertyBuilder builder = new SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").add(builder);this.javaSystemProperties.add(builder);} return (A)this;
  }
  public A removeFromJavaSystemProperties(io.strimzi.api.kafka.model.common.SystemProperty... items) {
    if (this.javaSystemProperties == null) return (A)this;
    for (SystemProperty item : items) {SystemPropertyBuilder builder = new SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").remove(builder); this.javaSystemProperties.remove(builder);} return (A)this;
  }
  public A removeAllFromJavaSystemProperties(Collection<SystemProperty> items) {
    if (this.javaSystemProperties == null) return (A)this;
    for (SystemProperty item : items) {SystemPropertyBuilder builder = new SystemPropertyBuilder(item);_visitables.get("javaSystemProperties").remove(builder); this.javaSystemProperties.remove(builder);} return (A)this;
  }
  public A removeMatchingFromJavaSystemProperties(Predicate<SystemPropertyBuilder> predicate) {
    if (javaSystemProperties == null) return (A) this;
    final Iterator<SystemPropertyBuilder> each = javaSystemProperties.iterator();
    final List visitables = _visitables.get("javaSystemProperties");
    while (each.hasNext()) {
      SystemPropertyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<SystemProperty> buildJavaSystemProperties() {
    return javaSystemProperties != null ? build(javaSystemProperties) : null;
  }
  public SystemProperty buildJavaSystemProperty(int index) {
    return this.javaSystemProperties.get(index).build();
  }
  public SystemProperty buildFirstJavaSystemProperty() {
    return this.javaSystemProperties.get(0).build();
  }
  public SystemProperty buildLastJavaSystemProperty() {
    return this.javaSystemProperties.get(javaSystemProperties.size() - 1).build();
  }
  public SystemProperty buildMatchingJavaSystemProperty(Predicate<SystemPropertyBuilder> predicate) {
    for (SystemPropertyBuilder item: javaSystemProperties) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingJavaSystemProperty(Predicate<SystemPropertyBuilder> predicate) {
    for (SystemPropertyBuilder item: javaSystemProperties) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withJavaSystemProperties(List<SystemProperty> javaSystemProperties) {
    if (this.javaSystemProperties != null) { _visitables.get("javaSystemProperties").clear();}
    if (javaSystemProperties != null) {this.javaSystemProperties = new ArrayList(); for (SystemProperty item : javaSystemProperties){this.addToJavaSystemProperties(item);}} else { this.javaSystemProperties = null;} return (A) this;
  }
  public A withJavaSystemProperties(io.strimzi.api.kafka.model.common.SystemProperty... javaSystemProperties) {
    if (this.javaSystemProperties != null) {this.javaSystemProperties.clear(); _visitables.remove("javaSystemProperties"); }
    if (javaSystemProperties != null) {for (SystemProperty item :javaSystemProperties){ this.addToJavaSystemProperties(item);}} return (A) this;
  }
  public boolean hasJavaSystemProperties() {
    return javaSystemProperties != null && !javaSystemProperties.isEmpty();
  }
  public JavaSystemPropertiesNested<A> addNewJavaSystemProperty() {
    return new JavaSystemPropertiesNested(-1, null);
  }
  public JavaSystemPropertiesNested<A> addNewJavaSystemPropertyLike(SystemProperty item) {
    return new JavaSystemPropertiesNested(-1, item);
  }
  public JavaSystemPropertiesNested<A> setNewJavaSystemPropertyLike(int index,SystemProperty item) {
    return new JavaSystemPropertiesNested(index, item);
  }
  public JavaSystemPropertiesNested<A> editJavaSystemProperty(int index) {
    if (javaSystemProperties.size() <= index) throw new RuntimeException("Can't edit javaSystemProperties. Index exceeds size.");
    return setNewJavaSystemPropertyLike(index, buildJavaSystemProperty(index));
  }
  public JavaSystemPropertiesNested<A> editFirstJavaSystemProperty() {
    if (javaSystemProperties.size() == 0) throw new RuntimeException("Can't edit first javaSystemProperties. The list is empty.");
    return setNewJavaSystemPropertyLike(0, buildJavaSystemProperty(0));
  }
  public JavaSystemPropertiesNested<A> editLastJavaSystemProperty() {
    int index = javaSystemProperties.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last javaSystemProperties. The list is empty.");
    return setNewJavaSystemPropertyLike(index, buildJavaSystemProperty(index));
  }
  public JavaSystemPropertiesNested<A> editMatchingJavaSystemProperty(Predicate<SystemPropertyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<javaSystemProperties.size();i++) { 
    if (predicate.test(javaSystemProperties.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching javaSystemProperties. No match found.");
    return setNewJavaSystemPropertyLike(index, buildJavaSystemProperty(index));
  }
  public A addToXx(String key,String value) {
    if(this.xx == null && key != null && value != null) { this.xx = new LinkedHashMap(); }
    if(key != null && value != null) {this.xx.put(key, value);} return (A)this;
  }
  public A addToXx(Map<String,String> map) {
    if(this.xx == null && map != null) { this.xx = new LinkedHashMap(); }
    if(map != null) { this.xx.putAll(map);} return (A)this;
  }
  public A removeFromXx(String key) {
    if(this.xx == null) { return (A) this; }
    if(key != null && this.xx != null) {this.xx.remove(key);} return (A)this;
  }
  public A removeFromXx(Map<String,String> map) {
    if(this.xx == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.xx != null){this.xx.remove(key);}}} return (A)this;
  }
  public Map<String,String> getXx() {
    return this.xx;
  }
  public <K,V>A withXx(Map<String,String> xx) {
    if (xx == null) { this.xx =  null;} else {this.xx = new LinkedHashMap(xx);} return (A) this;
  }
  public boolean hasXx() {
    return this.xx != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JvmOptionsFluent that = (JvmOptionsFluent) o;
    if (!java.util.Objects.equals(xmx, that.xmx)) return false;

    if (!java.util.Objects.equals(xms, that.xms)) return false;

    if (gcLoggingEnabled != that.gcLoggingEnabled) return false;
    if (!java.util.Objects.equals(javaSystemProperties, that.javaSystemProperties)) return false;

    if (!java.util.Objects.equals(xx, that.xx)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(xmx,  xms,  gcLoggingEnabled,  javaSystemProperties,  xx,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (xmx != null) { sb.append("xmx:"); sb.append(xmx + ","); }
    if (xms != null) { sb.append("xms:"); sb.append(xms + ","); }
    sb.append("gcLoggingEnabled:"); sb.append(gcLoggingEnabled + ",");
    if (javaSystemProperties != null && !javaSystemProperties.isEmpty()) { sb.append("javaSystemProperties:"); sb.append(javaSystemProperties + ","); }
    if (xx != null && !xx.isEmpty()) { sb.append("xx:"); sb.append(xx); }
    sb.append("}");
    return sb.toString();
  }
  public A withGcLoggingEnabled() {
    return withGcLoggingEnabled(true);
  }
  public class JavaSystemPropertiesNested<N> extends SystemPropertyFluent<JavaSystemPropertiesNested<N>> implements Nested<N>{
    JavaSystemPropertiesNested(int index,SystemProperty item) {
      this.index = index;
      this.builder = new SystemPropertyBuilder(this, item);
    }
    SystemPropertyBuilder builder;
    int index;
    public N and() {
      return (N) JvmOptionsFluent.this.setToJavaSystemProperties(index,builder.build());
    }
    public N endJavaSystemProperty() {
      return and();
    }
    
  }
  
}