package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PasswordBuilder extends PasswordFluent<PasswordBuilder> implements VisitableBuilder<Password,PasswordBuilder>{
  public PasswordBuilder() {
    this(false);
  }
  public PasswordBuilder(Boolean validationEnabled) {
    this(new Password(), validationEnabled);
  }
  public PasswordBuilder(PasswordFluent<?> fluent) {
    this(fluent, false);
  }
  public PasswordBuilder(PasswordFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Password(), validationEnabled);
  }
  public PasswordBuilder(PasswordFluent<?> fluent,Password instance) {
    this(fluent, instance, false);
  }
  public PasswordBuilder(PasswordFluent<?> fluent,Password instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Password());

    if (instance != null) {
      fluent.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PasswordBuilder(Password instance) {
    this(instance,false);
  }
  public PasswordBuilder(Password instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Password());

    if (instance != null) {
      this.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  PasswordFluent<?> fluent;
  Boolean validationEnabled;
  public Password build() {
    Password buildable = new Password();
    buildable.setValueFrom(fluent.buildValueFrom());
    return buildable;
  }
  
}