package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PasswordSecretSourceBuilder extends PasswordSecretSourceFluent<PasswordSecretSourceBuilder> implements VisitableBuilder<PasswordSecretSource,PasswordSecretSourceBuilder>{
  public PasswordSecretSourceBuilder() {
    this(false);
  }
  public PasswordSecretSourceBuilder(Boolean validationEnabled) {
    this(new PasswordSecretSource(), validationEnabled);
  }
  public PasswordSecretSourceBuilder(PasswordSecretSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PasswordSecretSourceBuilder(PasswordSecretSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PasswordSecretSource(), validationEnabled);
  }
  public PasswordSecretSourceBuilder(PasswordSecretSourceFluent<?> fluent,PasswordSecretSource instance) {
    this(fluent, instance, false);
  }
  public PasswordSecretSourceBuilder(PasswordSecretSourceFluent<?> fluent,PasswordSecretSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PasswordSecretSource());

    if (instance != null) {
      fluent.withSecretName(instance.getSecretName());
      fluent.withPassword(instance.getPassword());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PasswordSecretSourceBuilder(PasswordSecretSource instance) {
    this(instance,false);
  }
  public PasswordSecretSourceBuilder(PasswordSecretSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PasswordSecretSource());

    if (instance != null) {
      this.withSecretName(instance.getSecretName());
      this.withPassword(instance.getPassword());
    }
    this.validationEnabled = validationEnabled; 
  }
  PasswordSecretSourceFluent<?> fluent;
  Boolean validationEnabled;
  public PasswordSecretSource build() {
    PasswordSecretSource buildable = new PasswordSecretSource();
    buildable.setSecretName(fluent.getSecretName());
    buildable.setPassword(fluent.getPassword());
    return buildable;
  }
  
}