package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PasswordSourceBuilder extends PasswordSourceFluent<PasswordSourceBuilder> implements VisitableBuilder<PasswordSource,PasswordSourceBuilder>{
  public PasswordSourceBuilder() {
    this(false);
  }
  public PasswordSourceBuilder(Boolean validationEnabled) {
    this(new PasswordSource(), validationEnabled);
  }
  public PasswordSourceBuilder(PasswordSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PasswordSourceBuilder(PasswordSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PasswordSource(), validationEnabled);
  }
  public PasswordSourceBuilder(PasswordSourceFluent<?> fluent,PasswordSource instance) {
    this(fluent, instance, false);
  }
  public PasswordSourceBuilder(PasswordSourceFluent<?> fluent,PasswordSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PasswordSource());

    if (instance != null) {
      fluent.withSecretKeyRef(instance.getSecretKeyRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PasswordSourceBuilder(PasswordSource instance) {
    this(instance,false);
  }
  public PasswordSourceBuilder(PasswordSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PasswordSource());

    if (instance != null) {
      this.withSecretKeyRef(instance.getSecretKeyRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  PasswordSourceFluent<?> fluent;
  Boolean validationEnabled;
  public PasswordSource build() {
    PasswordSource buildable = new PasswordSource();
    buildable.setSecretKeyRef(fluent.getSecretKeyRef());
    return buildable;
  }
  
}