package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RackBuilder extends RackFluent<RackBuilder> implements VisitableBuilder<Rack,RackBuilder>{
  public RackBuilder() {
    this(false);
  }
  public RackBuilder(Boolean validationEnabled) {
    this(new Rack(), validationEnabled);
  }
  public RackBuilder(RackFluent<?> fluent) {
    this(fluent, false);
  }
  public RackBuilder(RackFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Rack(), validationEnabled);
  }
  public RackBuilder(RackFluent<?> fluent,Rack instance) {
    this(fluent, instance, false);
  }
  public RackBuilder(RackFluent<?> fluent,Rack instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Rack());

    if (instance != null) {
      fluent.withTopologyKey(instance.getTopologyKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RackBuilder(Rack instance) {
    this(instance,false);
  }
  public RackBuilder(Rack instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Rack());

    if (instance != null) {
      this.withTopologyKey(instance.getTopologyKey());
    }
    this.validationEnabled = validationEnabled; 
  }
  RackFluent<?> fluent;
  Boolean validationEnabled;
  public Rack build() {
    Rack buildable = new Rack(fluent.getTopologyKey());
    return buildable;
  }
  
}