package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SidecarBuilder extends SidecarFluent<SidecarBuilder> implements VisitableBuilder<Sidecar,SidecarBuilder>{
  public SidecarBuilder() {
    this(false);
  }
  public SidecarBuilder(Boolean validationEnabled) {
    this(new Sidecar(), validationEnabled);
  }
  public SidecarBuilder(SidecarFluent<?> fluent) {
    this(fluent, false);
  }
  public SidecarBuilder(SidecarFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Sidecar(), validationEnabled);
  }
  public SidecarBuilder(SidecarFluent<?> fluent,Sidecar instance) {
    this(fluent, instance, false);
  }
  public SidecarBuilder(SidecarFluent<?> fluent,Sidecar instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Sidecar());

    if (instance != null) {
      fluent.withImage(instance.getImage());
      fluent.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SidecarBuilder(Sidecar instance) {
    this(instance,false);
  }
  public SidecarBuilder(Sidecar instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Sidecar());

    if (instance != null) {
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
    }
    this.validationEnabled = validationEnabled; 
  }
  SidecarFluent<?> fluent;
  Boolean validationEnabled;
  public Sidecar build() {
    Sidecar buildable = new Sidecar();
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    return buildable;
  }
  
}