package io.strimzi.api.kafka.model.common.authentication;

import io.strimzi.api.kafka.model.common.GenericSecretSource;
import io.strimzi.api.kafka.model.common.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.common.PasswordSecretSourceBuilder;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.strimzi.api.kafka.model.common.GenericSecretSourceFluent;
import io.strimzi.api.kafka.model.common.PasswordSecretSource;
import io.strimzi.api.kafka.model.common.PasswordSecretSourceFluent;
import java.lang.Integer;
import io.strimzi.api.kafka.model.common.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.common.CertSecretSourceFluent;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.CertSecretSource;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaClientAuthenticationOAuthFluent<A extends KafkaClientAuthenticationOAuthFluent<A>> extends BaseFluent<A>{
  public KafkaClientAuthenticationOAuthFluent() {
  }
  public KafkaClientAuthenticationOAuthFluent(KafkaClientAuthenticationOAuth instance) {
    instance = (instance != null ? instance : new KafkaClientAuthenticationOAuth());

    if (instance != null) {
      this.withClientId(instance.getClientId());
      this.withUsername(instance.getUsername());
      this.withScope(instance.getScope());
      this.withAudience(instance.getAudience());
      this.withTokenEndpointUri(instance.getTokenEndpointUri());
      this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
      this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
      this.withHttpRetries(instance.getHttpRetries());
      this.withHttpRetryPauseMs(instance.getHttpRetryPauseMs());
      this.withClientSecret(instance.getClientSecret());
      this.withPasswordSecret(instance.getPasswordSecret());
      this.withAccessToken(instance.getAccessToken());
      this.withRefreshToken(instance.getRefreshToken());
      this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
      this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
      this.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
      this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
      this.withEnableMetrics(instance.isEnableMetrics());
      this.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
    }
  }
  private String clientId;
  private String username;
  private String scope;
  private String audience;
  private String tokenEndpointUri;
  private Integer connectTimeoutSeconds;
  private Integer readTimeoutSeconds;
  private Integer httpRetries;
  private Integer httpRetryPauseMs;
  private GenericSecretSourceBuilder clientSecret;
  private PasswordSecretSourceBuilder passwordSecret;
  private GenericSecretSourceBuilder accessToken;
  private GenericSecretSourceBuilder refreshToken;
  private ArrayList<CertSecretSourceBuilder> tlsTrustedCertificates;
  private boolean disableTlsHostnameVerification;
  private int maxTokenExpirySeconds;
  private boolean accessTokenIsJwt;
  private boolean enableMetrics;
  private boolean includeAcceptHeader;
  public String getClientId() {
    return this.clientId;
  }
  public A withClientId(String clientId) {
    this.clientId=clientId; return (A) this;
  }
  public boolean hasClientId() {
    return this.clientId != null;
  }
  public String getUsername() {
    return this.username;
  }
  public A withUsername(String username) {
    this.username=username; return (A) this;
  }
  public boolean hasUsername() {
    return this.username != null;
  }
  public String getScope() {
    return this.scope;
  }
  public A withScope(String scope) {
    this.scope=scope; return (A) this;
  }
  public boolean hasScope() {
    return this.scope != null;
  }
  public String getAudience() {
    return this.audience;
  }
  public A withAudience(String audience) {
    this.audience=audience; return (A) this;
  }
  public boolean hasAudience() {
    return this.audience != null;
  }
  public String getTokenEndpointUri() {
    return this.tokenEndpointUri;
  }
  public A withTokenEndpointUri(String tokenEndpointUri) {
    this.tokenEndpointUri=tokenEndpointUri; return (A) this;
  }
  public boolean hasTokenEndpointUri() {
    return this.tokenEndpointUri != null;
  }
  public Integer getConnectTimeoutSeconds() {
    return this.connectTimeoutSeconds;
  }
  public A withConnectTimeoutSeconds(Integer connectTimeoutSeconds) {
    this.connectTimeoutSeconds=connectTimeoutSeconds; return (A) this;
  }
  public boolean hasConnectTimeoutSeconds() {
    return this.connectTimeoutSeconds != null;
  }
  public Integer getReadTimeoutSeconds() {
    return this.readTimeoutSeconds;
  }
  public A withReadTimeoutSeconds(Integer readTimeoutSeconds) {
    this.readTimeoutSeconds=readTimeoutSeconds; return (A) this;
  }
  public boolean hasReadTimeoutSeconds() {
    return this.readTimeoutSeconds != null;
  }
  public Integer getHttpRetries() {
    return this.httpRetries;
  }
  public A withHttpRetries(Integer httpRetries) {
    this.httpRetries=httpRetries; return (A) this;
  }
  public boolean hasHttpRetries() {
    return this.httpRetries != null;
  }
  public Integer getHttpRetryPauseMs() {
    return this.httpRetryPauseMs;
  }
  public A withHttpRetryPauseMs(Integer httpRetryPauseMs) {
    this.httpRetryPauseMs=httpRetryPauseMs; return (A) this;
  }
  public boolean hasHttpRetryPauseMs() {
    return this.httpRetryPauseMs != null;
  }
  public GenericSecretSource buildClientSecret() {
    return this.clientSecret!=null ?this.clientSecret.build():null;
  }
  public A withClientSecret(GenericSecretSource clientSecret) {
    _visitables.get("clientSecret").remove(this.clientSecret);
    if (clientSecret!=null){ this.clientSecret= new GenericSecretSourceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} else { this.clientSecret = null; _visitables.get("clientSecret").remove(this.clientSecret); } return (A) this;
  }
  public boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  public ClientSecretNested<A> withNewClientSecret() {
    return new ClientSecretNested(null);
  }
  public ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item) {
    return new ClientSecretNested(item);
  }
  public ClientSecretNested<A> editClientSecret() {
    return withNewClientSecretLike(java.util.Optional.ofNullable(buildClientSecret()).orElse(null));
  }
  public ClientSecretNested<A> editOrNewClientSecret() {
    return withNewClientSecretLike(java.util.Optional.ofNullable(buildClientSecret()).orElse(new GenericSecretSourceBuilder().build()));
  }
  public ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item) {
    return withNewClientSecretLike(java.util.Optional.ofNullable(buildClientSecret()).orElse(item));
  }
  public PasswordSecretSource buildPasswordSecret() {
    return this.passwordSecret!=null ?this.passwordSecret.build():null;
  }
  public A withPasswordSecret(PasswordSecretSource passwordSecret) {
    _visitables.get("passwordSecret").remove(this.passwordSecret);
    if (passwordSecret!=null){ this.passwordSecret= new PasswordSecretSourceBuilder(passwordSecret); _visitables.get("passwordSecret").add(this.passwordSecret);} else { this.passwordSecret = null; _visitables.get("passwordSecret").remove(this.passwordSecret); } return (A) this;
  }
  public boolean hasPasswordSecret() {
    return this.passwordSecret != null;
  }
  public PasswordSecretNested<A> withNewPasswordSecret() {
    return new PasswordSecretNested(null);
  }
  public PasswordSecretNested<A> withNewPasswordSecretLike(PasswordSecretSource item) {
    return new PasswordSecretNested(item);
  }
  public PasswordSecretNested<A> editPasswordSecret() {
    return withNewPasswordSecretLike(java.util.Optional.ofNullable(buildPasswordSecret()).orElse(null));
  }
  public PasswordSecretNested<A> editOrNewPasswordSecret() {
    return withNewPasswordSecretLike(java.util.Optional.ofNullable(buildPasswordSecret()).orElse(new PasswordSecretSourceBuilder().build()));
  }
  public PasswordSecretNested<A> editOrNewPasswordSecretLike(PasswordSecretSource item) {
    return withNewPasswordSecretLike(java.util.Optional.ofNullable(buildPasswordSecret()).orElse(item));
  }
  public GenericSecretSource buildAccessToken() {
    return this.accessToken!=null ?this.accessToken.build():null;
  }
  public A withAccessToken(GenericSecretSource accessToken) {
    _visitables.get("accessToken").remove(this.accessToken);
    if (accessToken!=null){ this.accessToken= new GenericSecretSourceBuilder(accessToken); _visitables.get("accessToken").add(this.accessToken);} else { this.accessToken = null; _visitables.get("accessToken").remove(this.accessToken); } return (A) this;
  }
  public boolean hasAccessToken() {
    return this.accessToken != null;
  }
  public AccessTokenNested<A> withNewAccessToken() {
    return new AccessTokenNested(null);
  }
  public AccessTokenNested<A> withNewAccessTokenLike(GenericSecretSource item) {
    return new AccessTokenNested(item);
  }
  public AccessTokenNested<A> editAccessToken() {
    return withNewAccessTokenLike(java.util.Optional.ofNullable(buildAccessToken()).orElse(null));
  }
  public AccessTokenNested<A> editOrNewAccessToken() {
    return withNewAccessTokenLike(java.util.Optional.ofNullable(buildAccessToken()).orElse(new GenericSecretSourceBuilder().build()));
  }
  public AccessTokenNested<A> editOrNewAccessTokenLike(GenericSecretSource item) {
    return withNewAccessTokenLike(java.util.Optional.ofNullable(buildAccessToken()).orElse(item));
  }
  public GenericSecretSource buildRefreshToken() {
    return this.refreshToken!=null ?this.refreshToken.build():null;
  }
  public A withRefreshToken(GenericSecretSource refreshToken) {
    _visitables.get("refreshToken").remove(this.refreshToken);
    if (refreshToken!=null){ this.refreshToken= new GenericSecretSourceBuilder(refreshToken); _visitables.get("refreshToken").add(this.refreshToken);} else { this.refreshToken = null; _visitables.get("refreshToken").remove(this.refreshToken); } return (A) this;
  }
  public boolean hasRefreshToken() {
    return this.refreshToken != null;
  }
  public RefreshTokenNested<A> withNewRefreshToken() {
    return new RefreshTokenNested(null);
  }
  public RefreshTokenNested<A> withNewRefreshTokenLike(GenericSecretSource item) {
    return new RefreshTokenNested(item);
  }
  public RefreshTokenNested<A> editRefreshToken() {
    return withNewRefreshTokenLike(java.util.Optional.ofNullable(buildRefreshToken()).orElse(null));
  }
  public RefreshTokenNested<A> editOrNewRefreshToken() {
    return withNewRefreshTokenLike(java.util.Optional.ofNullable(buildRefreshToken()).orElse(new GenericSecretSourceBuilder().build()));
  }
  public RefreshTokenNested<A> editOrNewRefreshTokenLike(GenericSecretSource item) {
    return withNewRefreshTokenLike(java.util.Optional.ofNullable(buildRefreshToken()).orElse(item));
  }
  public A addToTlsTrustedCertificates(int index,CertSecretSource item) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
    if (index < 0 || index >= tlsTrustedCertificates.size()) { _visitables.get("tlsTrustedCertificates").add(builder); tlsTrustedCertificates.add(builder); } else { _visitables.get("tlsTrustedCertificates").add(index, builder); tlsTrustedCertificates.add(index, builder);}
    return (A)this;
  }
  public A setToTlsTrustedCertificates(int index,CertSecretSource item) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
    if (index < 0 || index >= tlsTrustedCertificates.size()) { _visitables.get("tlsTrustedCertificates").add(builder); tlsTrustedCertificates.add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder); tlsTrustedCertificates.set(index, builder);}
    return (A)this;
  }
  public A addToTlsTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... items) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
  }
  public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
  }
  public A removeFromTlsTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... items) {
    if (this.tlsTrustedCertificates == null) return (A)this;
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder); this.tlsTrustedCertificates.remove(builder);} return (A)this;
  }
  public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
    if (this.tlsTrustedCertificates == null) return (A)this;
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder); this.tlsTrustedCertificates.remove(builder);} return (A)this;
  }
  public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
    if (tlsTrustedCertificates == null) return (A) this;
    final Iterator<CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
    final List visitables = _visitables.get("tlsTrustedCertificates");
    while (each.hasNext()) {
      CertSecretSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<CertSecretSource> buildTlsTrustedCertificates() {
    return tlsTrustedCertificates != null ? build(tlsTrustedCertificates) : null;
  }
  public CertSecretSource buildTlsTrustedCertificate(int index) {
    return this.tlsTrustedCertificates.get(index).build();
  }
  public CertSecretSource buildFirstTlsTrustedCertificate() {
    return this.tlsTrustedCertificates.get(0).build();
  }
  public CertSecretSource buildLastTlsTrustedCertificate() {
    return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
  }
  public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
    if (this.tlsTrustedCertificates != null) { _visitables.get("tlsTrustedCertificates").clear();}
    if (tlsTrustedCertificates != null) {this.tlsTrustedCertificates = new ArrayList(); for (CertSecretSource item : tlsTrustedCertificates){this.addToTlsTrustedCertificates(item);}} else { this.tlsTrustedCertificates = null;} return (A) this;
  }
  public A withTlsTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... tlsTrustedCertificates) {
    if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.clear(); _visitables.remove("tlsTrustedCertificates"); }
    if (tlsTrustedCertificates != null) {for (CertSecretSource item :tlsTrustedCertificates){ this.addToTlsTrustedCertificates(item);}} return (A) this;
  }
  public boolean hasTlsTrustedCertificates() {
    return tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty();
  }
  public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
    return new TlsTrustedCertificatesNested(-1, null);
  }
  public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
    return new TlsTrustedCertificatesNested(-1, item);
  }
  public TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item) {
    return new TlsTrustedCertificatesNested(index, item);
  }
  public TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
    if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  public TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
    if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
    return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
  }
  public TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
    int index = tlsTrustedCertificates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  public TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tlsTrustedCertificates.size();i++) { 
    if (predicate.test(tlsTrustedCertificates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  public boolean isDisableTlsHostnameVerification() {
    return this.disableTlsHostnameVerification;
  }
  public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
    this.disableTlsHostnameVerification=disableTlsHostnameVerification; return (A) this;
  }
  public boolean hasDisableTlsHostnameVerification() {
    return true;
  }
  public int getMaxTokenExpirySeconds() {
    return this.maxTokenExpirySeconds;
  }
  public A withMaxTokenExpirySeconds(int maxTokenExpirySeconds) {
    this.maxTokenExpirySeconds=maxTokenExpirySeconds; return (A) this;
  }
  public boolean hasMaxTokenExpirySeconds() {
    return true;
  }
  public boolean isAccessTokenIsJwt() {
    return this.accessTokenIsJwt;
  }
  public A withAccessTokenIsJwt(boolean accessTokenIsJwt) {
    this.accessTokenIsJwt=accessTokenIsJwt; return (A) this;
  }
  public boolean hasAccessTokenIsJwt() {
    return true;
  }
  public boolean isEnableMetrics() {
    return this.enableMetrics;
  }
  public A withEnableMetrics(boolean enableMetrics) {
    this.enableMetrics=enableMetrics; return (A) this;
  }
  public boolean hasEnableMetrics() {
    return true;
  }
  public boolean isIncludeAcceptHeader() {
    return this.includeAcceptHeader;
  }
  public A withIncludeAcceptHeader(boolean includeAcceptHeader) {
    this.includeAcceptHeader=includeAcceptHeader; return (A) this;
  }
  public boolean hasIncludeAcceptHeader() {
    return true;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaClientAuthenticationOAuthFluent that = (KafkaClientAuthenticationOAuthFluent) o;
    if (!java.util.Objects.equals(clientId, that.clientId)) return false;

    if (!java.util.Objects.equals(username, that.username)) return false;

    if (!java.util.Objects.equals(scope, that.scope)) return false;

    if (!java.util.Objects.equals(audience, that.audience)) return false;

    if (!java.util.Objects.equals(tokenEndpointUri, that.tokenEndpointUri)) return false;

    if (!java.util.Objects.equals(connectTimeoutSeconds, that.connectTimeoutSeconds)) return false;

    if (!java.util.Objects.equals(readTimeoutSeconds, that.readTimeoutSeconds)) return false;

    if (!java.util.Objects.equals(httpRetries, that.httpRetries)) return false;

    if (!java.util.Objects.equals(httpRetryPauseMs, that.httpRetryPauseMs)) return false;

    if (!java.util.Objects.equals(clientSecret, that.clientSecret)) return false;

    if (!java.util.Objects.equals(passwordSecret, that.passwordSecret)) return false;

    if (!java.util.Objects.equals(accessToken, that.accessToken)) return false;

    if (!java.util.Objects.equals(refreshToken, that.refreshToken)) return false;

    if (!java.util.Objects.equals(tlsTrustedCertificates, that.tlsTrustedCertificates)) return false;

    if (disableTlsHostnameVerification != that.disableTlsHostnameVerification) return false;
    if (maxTokenExpirySeconds != that.maxTokenExpirySeconds) return false;
    if (accessTokenIsJwt != that.accessTokenIsJwt) return false;
    if (enableMetrics != that.enableMetrics) return false;
    if (includeAcceptHeader != that.includeAcceptHeader) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clientId,  username,  scope,  audience,  tokenEndpointUri,  connectTimeoutSeconds,  readTimeoutSeconds,  httpRetries,  httpRetryPauseMs,  clientSecret,  passwordSecret,  accessToken,  refreshToken,  tlsTrustedCertificates,  disableTlsHostnameVerification,  maxTokenExpirySeconds,  accessTokenIsJwt,  enableMetrics,  includeAcceptHeader,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientId != null) { sb.append("clientId:"); sb.append(clientId + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (scope != null) { sb.append("scope:"); sb.append(scope + ","); }
    if (audience != null) { sb.append("audience:"); sb.append(audience + ","); }
    if (tokenEndpointUri != null) { sb.append("tokenEndpointUri:"); sb.append(tokenEndpointUri + ","); }
    if (connectTimeoutSeconds != null) { sb.append("connectTimeoutSeconds:"); sb.append(connectTimeoutSeconds + ","); }
    if (readTimeoutSeconds != null) { sb.append("readTimeoutSeconds:"); sb.append(readTimeoutSeconds + ","); }
    if (httpRetries != null) { sb.append("httpRetries:"); sb.append(httpRetries + ","); }
    if (httpRetryPauseMs != null) { sb.append("httpRetryPauseMs:"); sb.append(httpRetryPauseMs + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (passwordSecret != null) { sb.append("passwordSecret:"); sb.append(passwordSecret + ","); }
    if (accessToken != null) { sb.append("accessToken:"); sb.append(accessToken + ","); }
    if (refreshToken != null) { sb.append("refreshToken:"); sb.append(refreshToken + ","); }
    if (tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty()) { sb.append("tlsTrustedCertificates:"); sb.append(tlsTrustedCertificates + ","); }
    sb.append("disableTlsHostnameVerification:"); sb.append(disableTlsHostnameVerification + ",");
    sb.append("maxTokenExpirySeconds:"); sb.append(maxTokenExpirySeconds + ",");
    sb.append("accessTokenIsJwt:"); sb.append(accessTokenIsJwt + ",");
    sb.append("enableMetrics:"); sb.append(enableMetrics + ",");
    sb.append("includeAcceptHeader:"); sb.append(includeAcceptHeader);
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.common."+"CertAndKeySecretSource": return (VisitableBuilder<T, ?>)new io.strimzi.api.kafka.model.common.CertAndKeySecretSourceBuilder((io.strimzi.api.kafka.model.common.CertAndKeySecretSource) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public A withDisableTlsHostnameVerification() {
    return withDisableTlsHostnameVerification(true);
  }
  public A withAccessTokenIsJwt() {
    return withAccessTokenIsJwt(true);
  }
  public A withEnableMetrics() {
    return withEnableMetrics(true);
  }
  public A withIncludeAcceptHeader() {
    return withIncludeAcceptHeader(true);
  }
  public class ClientSecretNested<N> extends GenericSecretSourceFluent<ClientSecretNested<N>> implements Nested<N>{
    ClientSecretNested(GenericSecretSource item) {
      this.builder = new GenericSecretSourceBuilder(this, item);
    }
    GenericSecretSourceBuilder builder;
    public N and() {
      return (N) KafkaClientAuthenticationOAuthFluent.this.withClientSecret(builder.build());
    }
    public N endClientSecret() {
      return and();
    }
    
  }
  public class PasswordSecretNested<N> extends PasswordSecretSourceFluent<PasswordSecretNested<N>> implements Nested<N>{
    PasswordSecretNested(PasswordSecretSource item) {
      this.builder = new PasswordSecretSourceBuilder(this, item);
    }
    PasswordSecretSourceBuilder builder;
    public N and() {
      return (N) KafkaClientAuthenticationOAuthFluent.this.withPasswordSecret(builder.build());
    }
    public N endPasswordSecret() {
      return and();
    }
    
  }
  public class AccessTokenNested<N> extends GenericSecretSourceFluent<AccessTokenNested<N>> implements Nested<N>{
    AccessTokenNested(GenericSecretSource item) {
      this.builder = new GenericSecretSourceBuilder(this, item);
    }
    GenericSecretSourceBuilder builder;
    public N and() {
      return (N) KafkaClientAuthenticationOAuthFluent.this.withAccessToken(builder.build());
    }
    public N endAccessToken() {
      return and();
    }
    
  }
  public class RefreshTokenNested<N> extends GenericSecretSourceFluent<RefreshTokenNested<N>> implements Nested<N>{
    RefreshTokenNested(GenericSecretSource item) {
      this.builder = new GenericSecretSourceBuilder(this, item);
    }
    GenericSecretSourceBuilder builder;
    public N and() {
      return (N) KafkaClientAuthenticationOAuthFluent.this.withRefreshToken(builder.build());
    }
    public N endRefreshToken() {
      return and();
    }
    
  }
  public class TlsTrustedCertificatesNested<N> extends CertSecretSourceFluent<TlsTrustedCertificatesNested<N>> implements Nested<N>{
    TlsTrustedCertificatesNested(int index,CertSecretSource item) {
      this.index = index;
      this.builder = new CertSecretSourceBuilder(this, item);
    }
    CertSecretSourceBuilder builder;
    int index;
    public N and() {
      return (N) KafkaClientAuthenticationOAuthFluent.this.setToTlsTrustedCertificates(index,builder.build());
    }
    public N endTlsTrustedCertificate() {
      return and();
    }
    
  }
  
}