package io.strimzi.api.kafka.model.common.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaClientAuthenticationScramSha256Builder extends KafkaClientAuthenticationScramSha256Fluent<KafkaClientAuthenticationScramSha256Builder> implements VisitableBuilder<KafkaClientAuthenticationScramSha256,KafkaClientAuthenticationScramSha256Builder>{
  public KafkaClientAuthenticationScramSha256Builder() {
    this(false);
  }
  public KafkaClientAuthenticationScramSha256Builder(Boolean validationEnabled) {
    this(new KafkaClientAuthenticationScramSha256(), validationEnabled);
  }
  public KafkaClientAuthenticationScramSha256Builder(KafkaClientAuthenticationScramSha256Fluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaClientAuthenticationScramSha256Builder(KafkaClientAuthenticationScramSha256Fluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaClientAuthenticationScramSha256(), validationEnabled);
  }
  public KafkaClientAuthenticationScramSha256Builder(KafkaClientAuthenticationScramSha256Fluent<?> fluent,KafkaClientAuthenticationScramSha256 instance) {
    this(fluent, instance, false);
  }
  public KafkaClientAuthenticationScramSha256Builder(KafkaClientAuthenticationScramSha256Fluent<?> fluent,KafkaClientAuthenticationScramSha256 instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaClientAuthenticationScramSha256());

    if (instance != null) {
      fluent.withUsername(instance.getUsername());
      fluent.withPasswordSecret(instance.getPasswordSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaClientAuthenticationScramSha256Builder(KafkaClientAuthenticationScramSha256 instance) {
    this(instance,false);
  }
  public KafkaClientAuthenticationScramSha256Builder(KafkaClientAuthenticationScramSha256 instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaClientAuthenticationScramSha256());

    if (instance != null) {
      this.withUsername(instance.getUsername());
      this.withPasswordSecret(instance.getPasswordSecret());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaClientAuthenticationScramSha256Fluent<?> fluent;
  Boolean validationEnabled;
  public KafkaClientAuthenticationScramSha256 build() {
    KafkaClientAuthenticationScramSha256 buildable = new KafkaClientAuthenticationScramSha256();
    buildable.setUsername(fluent.getUsername());
    buildable.setPasswordSecret(fluent.buildPasswordSecret());
    return buildable;
  }
  
}