package io.strimzi.api.kafka.model.common.jmx;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaJmxOptionsBuilder extends KafkaJmxOptionsFluent<KafkaJmxOptionsBuilder> implements VisitableBuilder<KafkaJmxOptions,KafkaJmxOptionsBuilder>{
  public KafkaJmxOptionsBuilder() {
    this(false);
  }
  public KafkaJmxOptionsBuilder(Boolean validationEnabled) {
    this(new KafkaJmxOptions(), validationEnabled);
  }
  public KafkaJmxOptionsBuilder(KafkaJmxOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaJmxOptionsBuilder(KafkaJmxOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaJmxOptions(), validationEnabled);
  }
  public KafkaJmxOptionsBuilder(KafkaJmxOptionsFluent<?> fluent,KafkaJmxOptions instance) {
    this(fluent, instance, false);
  }
  public KafkaJmxOptionsBuilder(KafkaJmxOptionsFluent<?> fluent,KafkaJmxOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaJmxOptions());

    if (instance != null) {
      fluent.withAuthentication(instance.getAuthentication());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaJmxOptionsBuilder(KafkaJmxOptions instance) {
    this(instance,false);
  }
  public KafkaJmxOptionsBuilder(KafkaJmxOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaJmxOptions());

    if (instance != null) {
      this.withAuthentication(instance.getAuthentication());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaJmxOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaJmxOptions build() {
    KafkaJmxOptions buildable = new KafkaJmxOptions();
    buildable.setAuthentication(fluent.buildAuthentication());
    return buildable;
  }
  
}