package io.strimzi.api.kafka.model.common.metrics;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JmxPrometheusExporterMetricsBuilder extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsBuilder> implements VisitableBuilder<JmxPrometheusExporterMetrics,JmxPrometheusExporterMetricsBuilder>{
  public JmxPrometheusExporterMetricsBuilder() {
    this(false);
  }
  public JmxPrometheusExporterMetricsBuilder(Boolean validationEnabled) {
    this(new JmxPrometheusExporterMetrics(), validationEnabled);
  }
  public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetricsFluent<?> fluent) {
    this(fluent, false);
  }
  public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetricsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JmxPrometheusExporterMetrics(), validationEnabled);
  }
  public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetricsFluent<?> fluent,JmxPrometheusExporterMetrics instance) {
    this(fluent, instance, false);
  }
  public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetricsFluent<?> fluent,JmxPrometheusExporterMetrics instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new JmxPrometheusExporterMetrics());

    if (instance != null) {
      fluent.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetrics instance) {
    this(instance,false);
  }
  public JmxPrometheusExporterMetricsBuilder(JmxPrometheusExporterMetrics instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new JmxPrometheusExporterMetrics());

    if (instance != null) {
      this.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  JmxPrometheusExporterMetricsFluent<?> fluent;
  Boolean validationEnabled;
  public JmxPrometheusExporterMetrics build() {
    JmxPrometheusExporterMetrics buildable = new JmxPrometheusExporterMetrics();
    buildable.setValueFrom(fluent.buildValueFrom());
    return buildable;
  }
  
}