package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentTemplateBuilder extends DeploymentTemplateFluent<DeploymentTemplateBuilder> implements VisitableBuilder<DeploymentTemplate,DeploymentTemplateBuilder>{
  public DeploymentTemplateBuilder() {
    this(false);
  }
  public DeploymentTemplateBuilder(Boolean validationEnabled) {
    this(new DeploymentTemplate(), validationEnabled);
  }
  public DeploymentTemplateBuilder(DeploymentTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentTemplateBuilder(DeploymentTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentTemplate(), validationEnabled);
  }
  public DeploymentTemplateBuilder(DeploymentTemplateFluent<?> fluent,DeploymentTemplate instance) {
    this(fluent, instance, false);
  }
  public DeploymentTemplateBuilder(DeploymentTemplateFluent<?> fluent,DeploymentTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DeploymentTemplate());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withDeploymentStrategy(instance.getDeploymentStrategy());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentTemplateBuilder(DeploymentTemplate instance) {
    this(instance,false);
  }
  public DeploymentTemplateBuilder(DeploymentTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DeploymentTemplate());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withDeploymentStrategy(instance.getDeploymentStrategy());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentTemplate build() {
    DeploymentTemplate buildable = new DeploymentTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setDeploymentStrategy(fluent.getDeploymentStrategy());
    return buildable;
  }
  
}