package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JmxTransTemplateBuilder extends JmxTransTemplateFluent<JmxTransTemplateBuilder> implements VisitableBuilder<JmxTransTemplate,JmxTransTemplateBuilder>{
  public JmxTransTemplateBuilder() {
    this(false);
  }
  public JmxTransTemplateBuilder(Boolean validationEnabled) {
    this(new JmxTransTemplate(), validationEnabled);
  }
  public JmxTransTemplateBuilder(JmxTransTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public JmxTransTemplateBuilder(JmxTransTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JmxTransTemplate(), validationEnabled);
  }
  public JmxTransTemplateBuilder(JmxTransTemplateFluent<?> fluent,JmxTransTemplate instance) {
    this(fluent, instance, false);
  }
  public JmxTransTemplateBuilder(JmxTransTemplateFluent<?> fluent,JmxTransTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new JmxTransTemplate());

    if (instance != null) {
      fluent.withDeployment(instance.getDeployment());
      fluent.withPod(instance.getPod());
      fluent.withContainer(instance.getContainer());
      fluent.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JmxTransTemplateBuilder(JmxTransTemplate instance) {
    this(instance,false);
  }
  public JmxTransTemplateBuilder(JmxTransTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new JmxTransTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPod(instance.getPod());
      this.withContainer(instance.getContainer());
      this.withServiceAccount(instance.getServiceAccount());
    }
    this.validationEnabled = validationEnabled; 
  }
  JmxTransTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public JmxTransTemplate build() {
    JmxTransTemplate buildable = new JmxTransTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setContainer(fluent.buildContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  
}