package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatefulSetTemplateBuilder extends StatefulSetTemplateFluent<StatefulSetTemplateBuilder> implements VisitableBuilder<StatefulSetTemplate,StatefulSetTemplateBuilder>{
  public StatefulSetTemplateBuilder() {
    this(false);
  }
  public StatefulSetTemplateBuilder(Boolean validationEnabled) {
    this(new StatefulSetTemplate(), validationEnabled);
  }
  public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatefulSetTemplate(), validationEnabled);
  }
  public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent,StatefulSetTemplate instance) {
    this(fluent, instance, false);
  }
  public StatefulSetTemplateBuilder(StatefulSetTemplateFluent<?> fluent,StatefulSetTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StatefulSetTemplate());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withPodManagementPolicy(instance.getPodManagementPolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetTemplateBuilder(StatefulSetTemplate instance) {
    this(instance,false);
  }
  public StatefulSetTemplateBuilder(StatefulSetTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StatefulSetTemplate());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withPodManagementPolicy(instance.getPodManagementPolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  StatefulSetTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public StatefulSetTemplate build() {
    StatefulSetTemplate buildable = new StatefulSetTemplate();
    buildable.setMetadata(fluent.buildMetadata());
    buildable.setPodManagementPolicy(fluent.getPodManagementPolicy());
    return buildable;
  }
  
}