package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalConfigurationBuilder extends ExternalConfigurationFluent<ExternalConfigurationBuilder> implements VisitableBuilder<ExternalConfiguration,ExternalConfigurationBuilder>{
  public ExternalConfigurationBuilder() {
    this(false);
  }
  public ExternalConfigurationBuilder(Boolean validationEnabled) {
    this(new ExternalConfiguration(), validationEnabled);
  }
  public ExternalConfigurationBuilder(ExternalConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalConfigurationBuilder(ExternalConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalConfiguration(), validationEnabled);
  }
  public ExternalConfigurationBuilder(ExternalConfigurationFluent<?> fluent,ExternalConfiguration instance) {
    this(fluent, instance, false);
  }
  public ExternalConfigurationBuilder(ExternalConfigurationFluent<?> fluent,ExternalConfiguration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExternalConfiguration());

    if (instance != null) {
      fluent.withEnv(instance.getEnv());
      fluent.withVolumes(instance.getVolumes());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalConfigurationBuilder(ExternalConfiguration instance) {
    this(instance,false);
  }
  public ExternalConfigurationBuilder(ExternalConfiguration instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExternalConfiguration());

    if (instance != null) {
      this.withEnv(instance.getEnv());
      this.withVolumes(instance.getVolumes());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalConfiguration build() {
    ExternalConfiguration buildable = new ExternalConfiguration();
    buildable.setEnv(fluent.buildEnv());
    buildable.setVolumes(fluent.buildVolumes());
    return buildable;
  }
  
}