package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalConfigurationEnvBuilder extends ExternalConfigurationEnvFluent<ExternalConfigurationEnvBuilder> implements VisitableBuilder<ExternalConfigurationEnv,ExternalConfigurationEnvBuilder>{
  public ExternalConfigurationEnvBuilder() {
    this(false);
  }
  public ExternalConfigurationEnvBuilder(Boolean validationEnabled) {
    this(new ExternalConfigurationEnv(), validationEnabled);
  }
  public ExternalConfigurationEnvBuilder(ExternalConfigurationEnvFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalConfigurationEnvBuilder(ExternalConfigurationEnvFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalConfigurationEnv(), validationEnabled);
  }
  public ExternalConfigurationEnvBuilder(ExternalConfigurationEnvFluent<?> fluent,ExternalConfigurationEnv instance) {
    this(fluent, instance, false);
  }
  public ExternalConfigurationEnvBuilder(ExternalConfigurationEnvFluent<?> fluent,ExternalConfigurationEnv instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExternalConfigurationEnv());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalConfigurationEnvBuilder(ExternalConfigurationEnv instance) {
    this(instance,false);
  }
  public ExternalConfigurationEnvBuilder(ExternalConfigurationEnv instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExternalConfigurationEnv());

    if (instance != null) {
      this.withName(instance.getName());
      this.withValueFrom(instance.getValueFrom());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalConfigurationEnvFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalConfigurationEnv build() {
    ExternalConfigurationEnv buildable = new ExternalConfigurationEnv();
    buildable.setName(fluent.getName());
    buildable.setValueFrom(fluent.buildValueFrom());
    return buildable;
  }
  
}