package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalConfigurationEnvVarSourceBuilder extends ExternalConfigurationEnvVarSourceFluent<ExternalConfigurationEnvVarSourceBuilder> implements VisitableBuilder<ExternalConfigurationEnvVarSource,ExternalConfigurationEnvVarSourceBuilder>{
  public ExternalConfigurationEnvVarSourceBuilder() {
    this(false);
  }
  public ExternalConfigurationEnvVarSourceBuilder(Boolean validationEnabled) {
    this(new ExternalConfigurationEnvVarSource(), validationEnabled);
  }
  public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalConfigurationEnvVarSource(), validationEnabled);
  }
  public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSourceFluent<?> fluent,ExternalConfigurationEnvVarSource instance) {
    this(fluent, instance, false);
  }
  public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSourceFluent<?> fluent,ExternalConfigurationEnvVarSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExternalConfigurationEnvVarSource());

    if (instance != null) {
      fluent.withSecretKeyRef(instance.getSecretKeyRef());
      fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSource instance) {
    this(instance,false);
  }
  public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExternalConfigurationEnvVarSource());

    if (instance != null) {
      this.withSecretKeyRef(instance.getSecretKeyRef());
      this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalConfigurationEnvVarSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalConfigurationEnvVarSource build() {
    ExternalConfigurationEnvVarSource buildable = new ExternalConfigurationEnvVarSource();
    buildable.setSecretKeyRef(fluent.getSecretKeyRef());
    buildable.setConfigMapKeyRef(fluent.getConfigMapKeyRef());
    return buildable;
  }
  
}