package io.strimzi.api.kafka.model.connect;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ExternalConfigurationEnvVarSourceFluent<A extends ExternalConfigurationEnvVarSourceFluent<A>> extends BaseFluent<A>{
  public ExternalConfigurationEnvVarSourceFluent() {
  }
  public ExternalConfigurationEnvVarSourceFluent(ExternalConfigurationEnvVarSource instance) {
    instance = (instance != null ? instance : new ExternalConfigurationEnvVarSource());

    if (instance != null) {
      this.withSecretKeyRef(instance.getSecretKeyRef());
      this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
    }
  }
  private SecretKeySelector secretKeyRef;
  private ConfigMapKeySelector configMapKeyRef;
  public SecretKeySelector getSecretKeyRef() {
    return this.secretKeyRef;
  }
  public A withSecretKeyRef(SecretKeySelector secretKeyRef) {
    this.secretKeyRef=secretKeyRef; return (A) this;
  }
  public boolean hasSecretKeyRef() {
    return this.secretKeyRef != null;
  }
  public A withNewSecretKeyRef(String key,String name,Boolean optional) {
    return (A)withSecretKeyRef(new SecretKeySelector(key, name, optional));
  }
  public ConfigMapKeySelector getConfigMapKeyRef() {
    return this.configMapKeyRef;
  }
  public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef) {
    this.configMapKeyRef=configMapKeyRef; return (A) this;
  }
  public boolean hasConfigMapKeyRef() {
    return this.configMapKeyRef != null;
  }
  public A withNewConfigMapKeyRef(String key,String name,Boolean optional) {
    return (A)withConfigMapKeyRef(new ConfigMapKeySelector(key, name, optional));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ExternalConfigurationEnvVarSourceFluent that = (ExternalConfigurationEnvVarSourceFluent) o;
    if (!java.util.Objects.equals(secretKeyRef, that.secretKeyRef)) return false;

    if (!java.util.Objects.equals(configMapKeyRef, that.configMapKeyRef)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(secretKeyRef,  configMapKeyRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (secretKeyRef != null) { sb.append("secretKeyRef:"); sb.append(secretKeyRef + ","); }
    if (configMapKeyRef != null) { sb.append("configMapKeyRef:"); sb.append(configMapKeyRef); }
    sb.append("}");
    return sb.toString();
  }
  
}