package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalConfigurationVolumeSourceBuilder extends ExternalConfigurationVolumeSourceFluent<ExternalConfigurationVolumeSourceBuilder> implements VisitableBuilder<ExternalConfigurationVolumeSource,ExternalConfigurationVolumeSourceBuilder>{
  public ExternalConfigurationVolumeSourceBuilder() {
    this(false);
  }
  public ExternalConfigurationVolumeSourceBuilder(Boolean validationEnabled) {
    this(new ExternalConfigurationVolumeSource(), validationEnabled);
  }
  public ExternalConfigurationVolumeSourceBuilder(ExternalConfigurationVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalConfigurationVolumeSourceBuilder(ExternalConfigurationVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalConfigurationVolumeSource(), validationEnabled);
  }
  public ExternalConfigurationVolumeSourceBuilder(ExternalConfigurationVolumeSourceFluent<?> fluent,ExternalConfigurationVolumeSource instance) {
    this(fluent, instance, false);
  }
  public ExternalConfigurationVolumeSourceBuilder(ExternalConfigurationVolumeSourceFluent<?> fluent,ExternalConfigurationVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExternalConfigurationVolumeSource());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withSecret(instance.getSecret());
      fluent.withConfigMap(instance.getConfigMap());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalConfigurationVolumeSourceBuilder(ExternalConfigurationVolumeSource instance) {
    this(instance,false);
  }
  public ExternalConfigurationVolumeSourceBuilder(ExternalConfigurationVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExternalConfigurationVolumeSource());

    if (instance != null) {
      this.withName(instance.getName());
      this.withSecret(instance.getSecret());
      this.withConfigMap(instance.getConfigMap());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalConfigurationVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalConfigurationVolumeSource build() {
    ExternalConfigurationVolumeSource buildable = new ExternalConfigurationVolumeSource();
    buildable.setName(fluent.getName());
    buildable.setSecret(fluent.getSecret());
    buildable.setConfigMap(fluent.getConfigMap());
    return buildable;
  }
  
}