package io.strimzi.api.kafka.model.connect;

import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.common.ClientTlsBuilder;
import io.strimzi.api.kafka.model.common.ClientTlsFluent;
import io.strimzi.api.kafka.model.connect.build.Build;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.common.ClientTls;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.connect.build.BuildFluent;
import io.strimzi.api.kafka.model.connect.build.BuildBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256Builder;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256Fluent;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaConnectSpecFluent<A extends KafkaConnectSpecFluent<A>> extends AbstractKafkaConnectSpecFluent<A>{
  public KafkaConnectSpecFluent() {
  }
  public KafkaConnectSpecFluent(KafkaConnectSpec instance) {
    instance = (instance != null ? instance : new KafkaConnectSpec());

    if (instance != null) {
      this.withConfig(instance.getConfig());
      this.withBootstrapServers(instance.getBootstrapServers());
      this.withTls(instance.getTls());
      this.withAuthentication(instance.getAuthentication());
      this.withBuild(instance.getBuild());
      this.withLogging(instance.getLogging());
      this.withReplicas(instance.getReplicas());
      this.withVersion(instance.getVersion());
      this.withImage(instance.getImage());
      this.withResources(instance.getResources());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withJmxOptions(instance.getJmxOptions());
      this.withJvmOptions(instance.getJvmOptions());
      this.withMetricsConfig(instance.getMetricsConfig());
      this.withTracing(instance.getTracing());
      this.withTemplate(instance.getTemplate());
      this.withExternalConfiguration(instance.getExternalConfiguration());
      this.withClientRackInitImage(instance.getClientRackInitImage());
      this.withRack(instance.getRack());
    }
  }
  private Map<String,Object> config;
  private String bootstrapServers;
  private ClientTlsBuilder tls;
  private VisitableBuilder<? extends KafkaClientAuthentication,?> authentication;
  private BuildBuilder build;
  public A addToConfig(String key,Object value) {
    if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap(); }
    if(key != null && value != null) {this.config.put(key, value);} return (A)this;
  }
  public A addToConfig(Map<String,Object> map) {
    if(this.config == null && map != null) { this.config = new LinkedHashMap(); }
    if(map != null) { this.config.putAll(map);} return (A)this;
  }
  public A removeFromConfig(String key) {
    if(this.config == null) { return (A) this; }
    if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
  }
  public A removeFromConfig(Map<String,Object> map) {
    if(this.config == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getConfig() {
    return this.config;
  }
  public <K,V>A withConfig(Map<String,Object> config) {
    if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap(config);} return (A) this;
  }
  public boolean hasConfig() {
    return this.config != null;
  }
  public String getBootstrapServers() {
    return this.bootstrapServers;
  }
  public A withBootstrapServers(String bootstrapServers) {
    this.bootstrapServers=bootstrapServers; return (A) this;
  }
  public boolean hasBootstrapServers() {
    return this.bootstrapServers != null;
  }
  public ClientTls buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public A withTls(ClientTls tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new ClientTlsBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  public boolean hasTls() {
    return this.tls != null;
  }
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  public TlsNested<A> withNewTlsLike(ClientTls item) {
    return new TlsNested(item);
  }
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new ClientTlsBuilder().build()));
  }
  public TlsNested<A> editOrNewTlsLike(ClientTls item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  public KafkaClientAuthentication buildAuthentication() {
    return this.authentication!=null?this.authentication.build():null;
  }
  public A withAuthentication(KafkaClientAuthentication authentication) {
    if (authentication==null){ this.authentication = null; _visitables.remove("authentication"); return (A) this;}
    VisitableBuilder<? extends KafkaClientAuthentication,?> builder = builder(authentication); _visitables.get("authentication").clear();_visitables.get("authentication").add(builder);this.authentication = builder;
    return (A) this;
  }
  public boolean hasAuthentication() {
    return this.authentication != null;
  }
  public KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
    return new KafkaClientAuthenticationScramSha512Nested(null);
  }
  public KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
    return new KafkaClientAuthenticationScramSha512Nested(item);
  }
  public KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
    return new KafkaClientAuthenticationTlsNested(null);
  }
  public KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
    return new KafkaClientAuthenticationTlsNested(item);
  }
  public KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
    return new KafkaClientAuthenticationOAuthNested(null);
  }
  public KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
    return new KafkaClientAuthenticationOAuthNested(item);
  }
  public KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256() {
    return new KafkaClientAuthenticationScramSha256Nested(null);
  }
  public KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(KafkaClientAuthenticationScramSha256 item) {
    return new KafkaClientAuthenticationScramSha256Nested(item);
  }
  public KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
    return new KafkaClientAuthenticationPlainNested(null);
  }
  public KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
    return new KafkaClientAuthenticationPlainNested(item);
  }
  public Build buildBuild() {
    return this.build!=null ?this.build.build():null;
  }
  public A withBuild(Build build) {
    _visitables.get("build").remove(this.build);
    if (build!=null){ this.build= new BuildBuilder(build); _visitables.get("build").add(this.build);} else { this.build = null; _visitables.get("build").remove(this.build); } return (A) this;
  }
  public boolean hasBuild() {
    return this.build != null;
  }
  public BuildNested<A> withNewBuild() {
    return new BuildNested(null);
  }
  public BuildNested<A> withNewBuildLike(Build item) {
    return new BuildNested(item);
  }
  public BuildNested<A> editBuild() {
    return withNewBuildLike(java.util.Optional.ofNullable(buildBuild()).orElse(null));
  }
  public BuildNested<A> editOrNewBuild() {
    return withNewBuildLike(java.util.Optional.ofNullable(buildBuild()).orElse(new BuildBuilder().build()));
  }
  public BuildNested<A> editOrNewBuildLike(Build item) {
    return withNewBuildLike(java.util.Optional.ofNullable(buildBuild()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaConnectSpecFluent that = (KafkaConnectSpecFluent) o;
    if (!java.util.Objects.equals(config, that.config)) return false;

    if (!java.util.Objects.equals(bootstrapServers, that.bootstrapServers)) return false;

    if (!java.util.Objects.equals(tls, that.tls)) return false;

    if (!java.util.Objects.equals(authentication, that.authentication)) return false;

    if (!java.util.Objects.equals(build, that.build)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(config,  bootstrapServers,  tls,  authentication,  build,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (config != null && !config.isEmpty()) { sb.append("config:"); sb.append(config + ","); }
    if (bootstrapServers != null) { sb.append("bootstrapServers:"); sb.append(bootstrapServers + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (authentication != null) { sb.append("authentication:"); sb.append(authentication + ","); }
    if (build != null) { sb.append("build:"); sb.append(build); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.common.authentication."+"KafkaClientAuthenticationScramSha512": return (VisitableBuilder<T, ?>)new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512) item);
    case "io.strimzi.api.kafka.model.common.authentication."+"KafkaClientAuthenticationTls": return (VisitableBuilder<T, ?>)new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls) item);
    case "io.strimzi.api.kafka.model.common.authentication."+"KafkaClientAuthenticationOAuth": return (VisitableBuilder<T, ?>)new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth) item);
    case "io.strimzi.api.kafka.model.common.authentication."+"KafkaClientAuthenticationScramSha256": return (VisitableBuilder<T, ?>)new KafkaClientAuthenticationScramSha256Builder((KafkaClientAuthenticationScramSha256) item);
    case "io.strimzi.api.kafka.model.common.authentication."+"KafkaClientAuthenticationPlain": return (VisitableBuilder<T, ?>)new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class TlsNested<N> extends ClientTlsFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(ClientTls item) {
      this.builder = new ClientTlsBuilder(this, item);
    }
    ClientTlsBuilder builder;
    public N and() {
      return (N) KafkaConnectSpecFluent.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  public class KafkaClientAuthenticationScramSha512Nested<N> extends KafkaClientAuthenticationScramSha512Fluent<KafkaClientAuthenticationScramSha512Nested<N>> implements Nested<N>{
    KafkaClientAuthenticationScramSha512Nested(KafkaClientAuthenticationScramSha512 item) {
      this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
    }
    KafkaClientAuthenticationScramSha512Builder builder;
    public N and() {
      return (N) KafkaConnectSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaClientAuthenticationScramSha512() {
      return and();
    }
    
  }
  public class KafkaClientAuthenticationTlsNested<N> extends KafkaClientAuthenticationTlsFluent<KafkaClientAuthenticationTlsNested<N>> implements Nested<N>{
    KafkaClientAuthenticationTlsNested(KafkaClientAuthenticationTls item) {
      this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
    }
    KafkaClientAuthenticationTlsBuilder builder;
    public N and() {
      return (N) KafkaConnectSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaClientAuthenticationTls() {
      return and();
    }
    
  }
  public class KafkaClientAuthenticationOAuthNested<N> extends KafkaClientAuthenticationOAuthFluent<KafkaClientAuthenticationOAuthNested<N>> implements Nested<N>{
    KafkaClientAuthenticationOAuthNested(KafkaClientAuthenticationOAuth item) {
      this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
    }
    KafkaClientAuthenticationOAuthBuilder builder;
    public N and() {
      return (N) KafkaConnectSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaClientAuthenticationOAuth() {
      return and();
    }
    
  }
  public class KafkaClientAuthenticationScramSha256Nested<N> extends KafkaClientAuthenticationScramSha256Fluent<KafkaClientAuthenticationScramSha256Nested<N>> implements Nested<N>{
    KafkaClientAuthenticationScramSha256Nested(KafkaClientAuthenticationScramSha256 item) {
      this.builder = new KafkaClientAuthenticationScramSha256Builder(this, item);
    }
    KafkaClientAuthenticationScramSha256Builder builder;
    public N and() {
      return (N) KafkaConnectSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaClientAuthenticationScramSha256() {
      return and();
    }
    
  }
  public class KafkaClientAuthenticationPlainNested<N> extends KafkaClientAuthenticationPlainFluent<KafkaClientAuthenticationPlainNested<N>> implements Nested<N>{
    KafkaClientAuthenticationPlainNested(KafkaClientAuthenticationPlain item) {
      this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
    }
    KafkaClientAuthenticationPlainBuilder builder;
    public N and() {
      return (N) KafkaConnectSpecFluent.this.withAuthentication(builder.build());
    }
    public N endKafkaClientAuthenticationPlain() {
      return and();
    }
    
  }
  public class BuildNested<N> extends BuildFluent<BuildNested<N>> implements Nested<N>{
    BuildNested(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildBuilder builder;
    public N and() {
      return (N) KafkaConnectSpecFluent.this.withBuild(builder.build());
    }
    public N endBuild() {
      return and();
    }
    
  }
  
}