package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaConnectStatusBuilder extends KafkaConnectStatusFluent<KafkaConnectStatusBuilder> implements VisitableBuilder<KafkaConnectStatus,KafkaConnectStatusBuilder>{
  public KafkaConnectStatusBuilder() {
    this(false);
  }
  public KafkaConnectStatusBuilder(Boolean validationEnabled) {
    this(new KafkaConnectStatus(), validationEnabled);
  }
  public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaConnectStatus(), validationEnabled);
  }
  public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent,KafkaConnectStatus instance) {
    this(fluent, instance, false);
  }
  public KafkaConnectStatusBuilder(KafkaConnectStatusFluent<?> fluent,KafkaConnectStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaConnectStatus());

    if (instance != null) {
      fluent.withUrl(instance.getUrl());
      fluent.withConnectorPlugins(instance.getConnectorPlugins());
      fluent.withReplicas(instance.getReplicas());
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaConnectStatusBuilder(KafkaConnectStatus instance) {
    this(instance,false);
  }
  public KafkaConnectStatusBuilder(KafkaConnectStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaConnectStatus());

    if (instance != null) {
      this.withUrl(instance.getUrl());
      this.withConnectorPlugins(instance.getConnectorPlugins());
      this.withReplicas(instance.getReplicas());
      this.withLabelSelector(instance.getLabelSelector());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaConnectStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaConnectStatus build() {
    KafkaConnectStatus buildable = new KafkaConnectStatus();
    buildable.setUrl(fluent.getUrl());
    buildable.setConnectorPlugins(fluent.buildConnectorPlugins());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setLabelSelector(fluent.getLabelSelector());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  
}