package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.kafka.StatusFluent;
import java.util.function.Predicate;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaConnectStatusFluent<A extends KafkaConnectStatusFluent<A>> extends StatusFluent<A>{
  public KafkaConnectStatusFluent() {
  }
  public KafkaConnectStatusFluent(KafkaConnectStatus instance) {
    instance = (instance != null ? instance : new KafkaConnectStatus());

    if (instance != null) {
      this.withUrl(instance.getUrl());
      this.withConnectorPlugins(instance.getConnectorPlugins());
      this.withReplicas(instance.getReplicas());
      this.withLabelSelector(instance.getLabelSelector());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
  }
  private String url;
  private ArrayList<ConnectorPluginBuilder> connectorPlugins;
  private int replicas;
  private String labelSelector;
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public boolean hasUrl() {
    return this.url != null;
  }
  public A addToConnectorPlugins(int index,ConnectorPlugin item) {
    if (this.connectorPlugins == null) {this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();}
    ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
    if (index < 0 || index >= connectorPlugins.size()) { _visitables.get("connectorPlugins").add(builder); connectorPlugins.add(builder); } else { _visitables.get("connectorPlugins").add(index, builder); connectorPlugins.add(index, builder);}
    return (A)this;
  }
  public A setToConnectorPlugins(int index,ConnectorPlugin item) {
    if (this.connectorPlugins == null) {this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();}
    ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);
    if (index < 0 || index >= connectorPlugins.size()) { _visitables.get("connectorPlugins").add(builder); connectorPlugins.add(builder); } else { _visitables.get("connectorPlugins").set(index, builder); connectorPlugins.set(index, builder);}
    return (A)this;
  }
  public A addToConnectorPlugins(io.strimzi.api.kafka.model.connect.ConnectorPlugin... items) {
    if (this.connectorPlugins == null) {this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();}
    for (ConnectorPlugin item : items) {ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").add(builder);this.connectorPlugins.add(builder);} return (A)this;
  }
  public A addAllToConnectorPlugins(Collection<ConnectorPlugin> items) {
    if (this.connectorPlugins == null) {this.connectorPlugins = new ArrayList<ConnectorPluginBuilder>();}
    for (ConnectorPlugin item : items) {ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").add(builder);this.connectorPlugins.add(builder);} return (A)this;
  }
  public A removeFromConnectorPlugins(io.strimzi.api.kafka.model.connect.ConnectorPlugin... items) {
    if (this.connectorPlugins == null) return (A)this;
    for (ConnectorPlugin item : items) {ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").remove(builder); this.connectorPlugins.remove(builder);} return (A)this;
  }
  public A removeAllFromConnectorPlugins(Collection<ConnectorPlugin> items) {
    if (this.connectorPlugins == null) return (A)this;
    for (ConnectorPlugin item : items) {ConnectorPluginBuilder builder = new ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").remove(builder); this.connectorPlugins.remove(builder);} return (A)this;
  }
  public A removeMatchingFromConnectorPlugins(Predicate<ConnectorPluginBuilder> predicate) {
    if (connectorPlugins == null) return (A) this;
    final Iterator<ConnectorPluginBuilder> each = connectorPlugins.iterator();
    final List visitables = _visitables.get("connectorPlugins");
    while (each.hasNext()) {
      ConnectorPluginBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ConnectorPlugin> buildConnectorPlugins() {
    return connectorPlugins != null ? build(connectorPlugins) : null;
  }
  public ConnectorPlugin buildConnectorPlugin(int index) {
    return this.connectorPlugins.get(index).build();
  }
  public ConnectorPlugin buildFirstConnectorPlugin() {
    return this.connectorPlugins.get(0).build();
  }
  public ConnectorPlugin buildLastConnectorPlugin() {
    return this.connectorPlugins.get(connectorPlugins.size() - 1).build();
  }
  public ConnectorPlugin buildMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
    for (ConnectorPluginBuilder item: connectorPlugins) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
    for (ConnectorPluginBuilder item: connectorPlugins) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConnectorPlugins(List<ConnectorPlugin> connectorPlugins) {
    if (this.connectorPlugins != null) { _visitables.get("connectorPlugins").clear();}
    if (connectorPlugins != null) {this.connectorPlugins = new ArrayList(); for (ConnectorPlugin item : connectorPlugins){this.addToConnectorPlugins(item);}} else { this.connectorPlugins = null;} return (A) this;
  }
  public A withConnectorPlugins(io.strimzi.api.kafka.model.connect.ConnectorPlugin... connectorPlugins) {
    if (this.connectorPlugins != null) {this.connectorPlugins.clear(); _visitables.remove("connectorPlugins"); }
    if (connectorPlugins != null) {for (ConnectorPlugin item :connectorPlugins){ this.addToConnectorPlugins(item);}} return (A) this;
  }
  public boolean hasConnectorPlugins() {
    return connectorPlugins != null && !connectorPlugins.isEmpty();
  }
  public ConnectorPluginsNested<A> addNewConnectorPlugin() {
    return new ConnectorPluginsNested(-1, null);
  }
  public ConnectorPluginsNested<A> addNewConnectorPluginLike(ConnectorPlugin item) {
    return new ConnectorPluginsNested(-1, item);
  }
  public ConnectorPluginsNested<A> setNewConnectorPluginLike(int index,ConnectorPlugin item) {
    return new ConnectorPluginsNested(index, item);
  }
  public ConnectorPluginsNested<A> editConnectorPlugin(int index) {
    if (connectorPlugins.size() <= index) throw new RuntimeException("Can't edit connectorPlugins. Index exceeds size.");
    return setNewConnectorPluginLike(index, buildConnectorPlugin(index));
  }
  public ConnectorPluginsNested<A> editFirstConnectorPlugin() {
    if (connectorPlugins.size() == 0) throw new RuntimeException("Can't edit first connectorPlugins. The list is empty.");
    return setNewConnectorPluginLike(0, buildConnectorPlugin(0));
  }
  public ConnectorPluginsNested<A> editLastConnectorPlugin() {
    int index = connectorPlugins.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last connectorPlugins. The list is empty.");
    return setNewConnectorPluginLike(index, buildConnectorPlugin(index));
  }
  public ConnectorPluginsNested<A> editMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate) {
    int index = -1;
    for (int i=0;i<connectorPlugins.size();i++) { 
    if (predicate.test(connectorPlugins.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching connectorPlugins. No match found.");
    return setNewConnectorPluginLike(index, buildConnectorPlugin(index));
  }
  public int getReplicas() {
    return this.replicas;
  }
  public A withReplicas(int replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return true;
  }
  public String getLabelSelector() {
    return this.labelSelector;
  }
  public A withLabelSelector(String labelSelector) {
    this.labelSelector=labelSelector; return (A) this;
  }
  public boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaConnectStatusFluent that = (KafkaConnectStatusFluent) o;
    if (!java.util.Objects.equals(url, that.url)) return false;

    if (!java.util.Objects.equals(connectorPlugins, that.connectorPlugins)) return false;

    if (replicas != that.replicas) return false;
    if (!java.util.Objects.equals(labelSelector, that.labelSelector)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(url,  connectorPlugins,  replicas,  labelSelector,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (connectorPlugins != null && !connectorPlugins.isEmpty()) { sb.append("connectorPlugins:"); sb.append(connectorPlugins + ","); }
    sb.append("replicas:"); sb.append(replicas + ",");
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector); }
    sb.append("}");
    return sb.toString();
  }
  public class ConnectorPluginsNested<N> extends ConnectorPluginFluent<ConnectorPluginsNested<N>> implements Nested<N>{
    ConnectorPluginsNested(int index,ConnectorPlugin item) {
      this.index = index;
      this.builder = new ConnectorPluginBuilder(this, item);
    }
    ConnectorPluginBuilder builder;
    int index;
    public N and() {
      return (N) KafkaConnectStatusFluent.this.setToConnectorPlugins(index,builder.build());
    }
    public N endConnectorPlugin() {
      return and();
    }
    
  }
  
}