package io.strimzi.api.kafka.model.connect;

import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.BuildConfigTemplateBuilder;
import java.lang.String;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplate;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplate;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.BuildConfigTemplate;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.BuildConfigTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateFluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KafkaConnectTemplateFluent<A extends KafkaConnectTemplateFluent<A>> extends BaseFluent<A>{
  public KafkaConnectTemplateFluent() {
  }
  public KafkaConnectTemplateFluent(KafkaConnectTemplate instance) {
    instance = (instance != null ? instance : new KafkaConnectTemplate());

    if (instance != null) {
      this.withDeployment(instance.getDeployment());
      this.withPodSet(instance.getPodSet());
      this.withPod(instance.getPod());
      this.withBuildPod(instance.getBuildPod());
      this.withApiService(instance.getApiService());
      this.withHeadlessService(instance.getHeadlessService());
      this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
      this.withConnectContainer(instance.getConnectContainer());
      this.withInitContainer(instance.getInitContainer());
      this.withBuildContainer(instance.getBuildContainer());
      this.withBuildConfig(instance.getBuildConfig());
      this.withClusterRoleBinding(instance.getClusterRoleBinding());
      this.withServiceAccount(instance.getServiceAccount());
      this.withBuildServiceAccount(instance.getBuildServiceAccount());
      this.withJmxSecret(instance.getJmxSecret());
    }
  }
  private DeploymentTemplateBuilder deployment;
  private ResourceTemplateBuilder podSet;
  private PodTemplateBuilder pod;
  private PodTemplateBuilder buildPod;
  private InternalServiceTemplateBuilder apiService;
  private InternalServiceTemplateBuilder headlessService;
  private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
  private ContainerTemplateBuilder connectContainer;
  private ContainerTemplateBuilder initContainer;
  private ContainerTemplateBuilder buildContainer;
  private BuildConfigTemplateBuilder buildConfig;
  private ResourceTemplateBuilder clusterRoleBinding;
  private ResourceTemplateBuilder serviceAccount;
  private ResourceTemplateBuilder buildServiceAccount;
  private ResourceTemplateBuilder jmxSecret;
  public DeploymentTemplate buildDeployment() {
    return this.deployment!=null ?this.deployment.build():null;
  }
  public A withDeployment(DeploymentTemplate deployment) {
    _visitables.get("deployment").remove(this.deployment);
    if (deployment!=null){ this.deployment= new DeploymentTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} else { this.deployment = null; _visitables.get("deployment").remove(this.deployment); } return (A) this;
  }
  public boolean hasDeployment() {
    return this.deployment != null;
  }
  public DeploymentNested<A> withNewDeployment() {
    return new DeploymentNested(null);
  }
  public DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item) {
    return new DeploymentNested(item);
  }
  public DeploymentNested<A> editDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(null));
  }
  public DeploymentNested<A> editOrNewDeployment() {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(new DeploymentTemplateBuilder().build()));
  }
  public DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item) {
    return withNewDeploymentLike(java.util.Optional.ofNullable(buildDeployment()).orElse(item));
  }
  public ResourceTemplate buildPodSet() {
    return this.podSet!=null ?this.podSet.build():null;
  }
  public A withPodSet(ResourceTemplate podSet) {
    _visitables.get("podSet").remove(this.podSet);
    if (podSet!=null){ this.podSet= new ResourceTemplateBuilder(podSet); _visitables.get("podSet").add(this.podSet);} else { this.podSet = null; _visitables.get("podSet").remove(this.podSet); } return (A) this;
  }
  public boolean hasPodSet() {
    return this.podSet != null;
  }
  public PodSetNested<A> withNewPodSet() {
    return new PodSetNested(null);
  }
  public PodSetNested<A> withNewPodSetLike(ResourceTemplate item) {
    return new PodSetNested(item);
  }
  public PodSetNested<A> editPodSet() {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(null));
  }
  public PodSetNested<A> editOrNewPodSet() {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(new ResourceTemplateBuilder().build()));
  }
  public PodSetNested<A> editOrNewPodSetLike(ResourceTemplate item) {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(item));
  }
  public PodTemplate buildPod() {
    return this.pod!=null ?this.pod.build():null;
  }
  public A withPod(PodTemplate pod) {
    _visitables.get("pod").remove(this.pod);
    if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} else { this.pod = null; _visitables.get("pod").remove(this.pod); } return (A) this;
  }
  public boolean hasPod() {
    return this.pod != null;
  }
  public PodNested<A> withNewPod() {
    return new PodNested(null);
  }
  public PodNested<A> withNewPodLike(PodTemplate item) {
    return new PodNested(item);
  }
  public PodNested<A> editPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(null));
  }
  public PodNested<A> editOrNewPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(new PodTemplateBuilder().build()));
  }
  public PodNested<A> editOrNewPodLike(PodTemplate item) {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(item));
  }
  public PodTemplate buildBuildPod() {
    return this.buildPod!=null ?this.buildPod.build():null;
  }
  public A withBuildPod(PodTemplate buildPod) {
    _visitables.get("buildPod").remove(this.buildPod);
    if (buildPod!=null){ this.buildPod= new PodTemplateBuilder(buildPod); _visitables.get("buildPod").add(this.buildPod);} else { this.buildPod = null; _visitables.get("buildPod").remove(this.buildPod); } return (A) this;
  }
  public boolean hasBuildPod() {
    return this.buildPod != null;
  }
  public BuildPodNested<A> withNewBuildPod() {
    return new BuildPodNested(null);
  }
  public BuildPodNested<A> withNewBuildPodLike(PodTemplate item) {
    return new BuildPodNested(item);
  }
  public BuildPodNested<A> editBuildPod() {
    return withNewBuildPodLike(java.util.Optional.ofNullable(buildBuildPod()).orElse(null));
  }
  public BuildPodNested<A> editOrNewBuildPod() {
    return withNewBuildPodLike(java.util.Optional.ofNullable(buildBuildPod()).orElse(new PodTemplateBuilder().build()));
  }
  public BuildPodNested<A> editOrNewBuildPodLike(PodTemplate item) {
    return withNewBuildPodLike(java.util.Optional.ofNullable(buildBuildPod()).orElse(item));
  }
  public InternalServiceTemplate buildApiService() {
    return this.apiService!=null ?this.apiService.build():null;
  }
  public A withApiService(InternalServiceTemplate apiService) {
    _visitables.get("apiService").remove(this.apiService);
    if (apiService!=null){ this.apiService= new InternalServiceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} else { this.apiService = null; _visitables.get("apiService").remove(this.apiService); } return (A) this;
  }
  public boolean hasApiService() {
    return this.apiService != null;
  }
  public ApiServiceNested<A> withNewApiService() {
    return new ApiServiceNested(null);
  }
  public ApiServiceNested<A> withNewApiServiceLike(InternalServiceTemplate item) {
    return new ApiServiceNested(item);
  }
  public ApiServiceNested<A> editApiService() {
    return withNewApiServiceLike(java.util.Optional.ofNullable(buildApiService()).orElse(null));
  }
  public ApiServiceNested<A> editOrNewApiService() {
    return withNewApiServiceLike(java.util.Optional.ofNullable(buildApiService()).orElse(new InternalServiceTemplateBuilder().build()));
  }
  public ApiServiceNested<A> editOrNewApiServiceLike(InternalServiceTemplate item) {
    return withNewApiServiceLike(java.util.Optional.ofNullable(buildApiService()).orElse(item));
  }
  public InternalServiceTemplate buildHeadlessService() {
    return this.headlessService!=null ?this.headlessService.build():null;
  }
  public A withHeadlessService(InternalServiceTemplate headlessService) {
    _visitables.get("headlessService").remove(this.headlessService);
    if (headlessService!=null){ this.headlessService= new InternalServiceTemplateBuilder(headlessService); _visitables.get("headlessService").add(this.headlessService);} else { this.headlessService = null; _visitables.get("headlessService").remove(this.headlessService); } return (A) this;
  }
  public boolean hasHeadlessService() {
    return this.headlessService != null;
  }
  public HeadlessServiceNested<A> withNewHeadlessService() {
    return new HeadlessServiceNested(null);
  }
  public HeadlessServiceNested<A> withNewHeadlessServiceLike(InternalServiceTemplate item) {
    return new HeadlessServiceNested(item);
  }
  public HeadlessServiceNested<A> editHeadlessService() {
    return withNewHeadlessServiceLike(java.util.Optional.ofNullable(buildHeadlessService()).orElse(null));
  }
  public HeadlessServiceNested<A> editOrNewHeadlessService() {
    return withNewHeadlessServiceLike(java.util.Optional.ofNullable(buildHeadlessService()).orElse(new InternalServiceTemplateBuilder().build()));
  }
  public HeadlessServiceNested<A> editOrNewHeadlessServiceLike(InternalServiceTemplate item) {
    return withNewHeadlessServiceLike(java.util.Optional.ofNullable(buildHeadlessService()).orElse(item));
  }
  public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
    return this.podDisruptionBudget!=null ?this.podDisruptionBudget.build():null;
  }
  public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
    _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
    if (podDisruptionBudget!=null){ this.podDisruptionBudget= new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} else { this.podDisruptionBudget = null; _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget); } return (A) this;
  }
  public boolean hasPodDisruptionBudget() {
    return this.podDisruptionBudget != null;
  }
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
    return new PodDisruptionBudgetNested(null);
  }
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return new PodDisruptionBudgetNested(item);
  }
  public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(null));
  }
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
  }
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(item));
  }
  public ContainerTemplate buildConnectContainer() {
    return this.connectContainer!=null ?this.connectContainer.build():null;
  }
  public A withConnectContainer(ContainerTemplate connectContainer) {
    _visitables.get("connectContainer").remove(this.connectContainer);
    if (connectContainer!=null){ this.connectContainer= new ContainerTemplateBuilder(connectContainer); _visitables.get("connectContainer").add(this.connectContainer);} else { this.connectContainer = null; _visitables.get("connectContainer").remove(this.connectContainer); } return (A) this;
  }
  public boolean hasConnectContainer() {
    return this.connectContainer != null;
  }
  public ConnectContainerNested<A> withNewConnectContainer() {
    return new ConnectContainerNested(null);
  }
  public ConnectContainerNested<A> withNewConnectContainerLike(ContainerTemplate item) {
    return new ConnectContainerNested(item);
  }
  public ConnectContainerNested<A> editConnectContainer() {
    return withNewConnectContainerLike(java.util.Optional.ofNullable(buildConnectContainer()).orElse(null));
  }
  public ConnectContainerNested<A> editOrNewConnectContainer() {
    return withNewConnectContainerLike(java.util.Optional.ofNullable(buildConnectContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public ConnectContainerNested<A> editOrNewConnectContainerLike(ContainerTemplate item) {
    return withNewConnectContainerLike(java.util.Optional.ofNullable(buildConnectContainer()).orElse(item));
  }
  public ContainerTemplate buildInitContainer() {
    return this.initContainer!=null ?this.initContainer.build():null;
  }
  public A withInitContainer(ContainerTemplate initContainer) {
    _visitables.get("initContainer").remove(this.initContainer);
    if (initContainer!=null){ this.initContainer= new ContainerTemplateBuilder(initContainer); _visitables.get("initContainer").add(this.initContainer);} else { this.initContainer = null; _visitables.get("initContainer").remove(this.initContainer); } return (A) this;
  }
  public boolean hasInitContainer() {
    return this.initContainer != null;
  }
  public InitContainerNested<A> withNewInitContainer() {
    return new InitContainerNested(null);
  }
  public InitContainerNested<A> withNewInitContainerLike(ContainerTemplate item) {
    return new InitContainerNested(item);
  }
  public InitContainerNested<A> editInitContainer() {
    return withNewInitContainerLike(java.util.Optional.ofNullable(buildInitContainer()).orElse(null));
  }
  public InitContainerNested<A> editOrNewInitContainer() {
    return withNewInitContainerLike(java.util.Optional.ofNullable(buildInitContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public InitContainerNested<A> editOrNewInitContainerLike(ContainerTemplate item) {
    return withNewInitContainerLike(java.util.Optional.ofNullable(buildInitContainer()).orElse(item));
  }
  public ContainerTemplate buildBuildContainer() {
    return this.buildContainer!=null ?this.buildContainer.build():null;
  }
  public A withBuildContainer(ContainerTemplate buildContainer) {
    _visitables.get("buildContainer").remove(this.buildContainer);
    if (buildContainer!=null){ this.buildContainer= new ContainerTemplateBuilder(buildContainer); _visitables.get("buildContainer").add(this.buildContainer);} else { this.buildContainer = null; _visitables.get("buildContainer").remove(this.buildContainer); } return (A) this;
  }
  public boolean hasBuildContainer() {
    return this.buildContainer != null;
  }
  public BuildContainerNested<A> withNewBuildContainer() {
    return new BuildContainerNested(null);
  }
  public BuildContainerNested<A> withNewBuildContainerLike(ContainerTemplate item) {
    return new BuildContainerNested(item);
  }
  public BuildContainerNested<A> editBuildContainer() {
    return withNewBuildContainerLike(java.util.Optional.ofNullable(buildBuildContainer()).orElse(null));
  }
  public BuildContainerNested<A> editOrNewBuildContainer() {
    return withNewBuildContainerLike(java.util.Optional.ofNullable(buildBuildContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  public BuildContainerNested<A> editOrNewBuildContainerLike(ContainerTemplate item) {
    return withNewBuildContainerLike(java.util.Optional.ofNullable(buildBuildContainer()).orElse(item));
  }
  public BuildConfigTemplate buildBuildConfig() {
    return this.buildConfig!=null ?this.buildConfig.build():null;
  }
  public A withBuildConfig(BuildConfigTemplate buildConfig) {
    _visitables.get("buildConfig").remove(this.buildConfig);
    if (buildConfig!=null){ this.buildConfig= new BuildConfigTemplateBuilder(buildConfig); _visitables.get("buildConfig").add(this.buildConfig);} else { this.buildConfig = null; _visitables.get("buildConfig").remove(this.buildConfig); } return (A) this;
  }
  public boolean hasBuildConfig() {
    return this.buildConfig != null;
  }
  public BuildConfigNested<A> withNewBuildConfig() {
    return new BuildConfigNested(null);
  }
  public BuildConfigNested<A> withNewBuildConfigLike(BuildConfigTemplate item) {
    return new BuildConfigNested(item);
  }
  public BuildConfigNested<A> editBuildConfig() {
    return withNewBuildConfigLike(java.util.Optional.ofNullable(buildBuildConfig()).orElse(null));
  }
  public BuildConfigNested<A> editOrNewBuildConfig() {
    return withNewBuildConfigLike(java.util.Optional.ofNullable(buildBuildConfig()).orElse(new BuildConfigTemplateBuilder().build()));
  }
  public BuildConfigNested<A> editOrNewBuildConfigLike(BuildConfigTemplate item) {
    return withNewBuildConfigLike(java.util.Optional.ofNullable(buildBuildConfig()).orElse(item));
  }
  public ResourceTemplate buildClusterRoleBinding() {
    return this.clusterRoleBinding!=null ?this.clusterRoleBinding.build():null;
  }
  public A withClusterRoleBinding(ResourceTemplate clusterRoleBinding) {
    _visitables.get("clusterRoleBinding").remove(this.clusterRoleBinding);
    if (clusterRoleBinding!=null){ this.clusterRoleBinding= new ResourceTemplateBuilder(clusterRoleBinding); _visitables.get("clusterRoleBinding").add(this.clusterRoleBinding);} else { this.clusterRoleBinding = null; _visitables.get("clusterRoleBinding").remove(this.clusterRoleBinding); } return (A) this;
  }
  public boolean hasClusterRoleBinding() {
    return this.clusterRoleBinding != null;
  }
  public ClusterRoleBindingNested<A> withNewClusterRoleBinding() {
    return new ClusterRoleBindingNested(null);
  }
  public ClusterRoleBindingNested<A> withNewClusterRoleBindingLike(ResourceTemplate item) {
    return new ClusterRoleBindingNested(item);
  }
  public ClusterRoleBindingNested<A> editClusterRoleBinding() {
    return withNewClusterRoleBindingLike(java.util.Optional.ofNullable(buildClusterRoleBinding()).orElse(null));
  }
  public ClusterRoleBindingNested<A> editOrNewClusterRoleBinding() {
    return withNewClusterRoleBindingLike(java.util.Optional.ofNullable(buildClusterRoleBinding()).orElse(new ResourceTemplateBuilder().build()));
  }
  public ClusterRoleBindingNested<A> editOrNewClusterRoleBindingLike(ResourceTemplate item) {
    return withNewClusterRoleBindingLike(java.util.Optional.ofNullable(buildClusterRoleBinding()).orElse(item));
  }
  public ResourceTemplate buildServiceAccount() {
    return this.serviceAccount!=null ?this.serviceAccount.build():null;
  }
  public A withServiceAccount(ResourceTemplate serviceAccount) {
    _visitables.get("serviceAccount").remove(this.serviceAccount);
    if (serviceAccount!=null){ this.serviceAccount= new ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} else { this.serviceAccount = null; _visitables.get("serviceAccount").remove(this.serviceAccount); } return (A) this;
  }
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public ServiceAccountNested<A> withNewServiceAccount() {
    return new ServiceAccountNested(null);
  }
  public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
    return new ServiceAccountNested(item);
  }
  public ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(null));
  }
  public ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
  }
  public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(item));
  }
  public ResourceTemplate buildBuildServiceAccount() {
    return this.buildServiceAccount!=null ?this.buildServiceAccount.build():null;
  }
  public A withBuildServiceAccount(ResourceTemplate buildServiceAccount) {
    _visitables.get("buildServiceAccount").remove(this.buildServiceAccount);
    if (buildServiceAccount!=null){ this.buildServiceAccount= new ResourceTemplateBuilder(buildServiceAccount); _visitables.get("buildServiceAccount").add(this.buildServiceAccount);} else { this.buildServiceAccount = null; _visitables.get("buildServiceAccount").remove(this.buildServiceAccount); } return (A) this;
  }
  public boolean hasBuildServiceAccount() {
    return this.buildServiceAccount != null;
  }
  public BuildServiceAccountNested<A> withNewBuildServiceAccount() {
    return new BuildServiceAccountNested(null);
  }
  public BuildServiceAccountNested<A> withNewBuildServiceAccountLike(ResourceTemplate item) {
    return new BuildServiceAccountNested(item);
  }
  public BuildServiceAccountNested<A> editBuildServiceAccount() {
    return withNewBuildServiceAccountLike(java.util.Optional.ofNullable(buildBuildServiceAccount()).orElse(null));
  }
  public BuildServiceAccountNested<A> editOrNewBuildServiceAccount() {
    return withNewBuildServiceAccountLike(java.util.Optional.ofNullable(buildBuildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
  }
  public BuildServiceAccountNested<A> editOrNewBuildServiceAccountLike(ResourceTemplate item) {
    return withNewBuildServiceAccountLike(java.util.Optional.ofNullable(buildBuildServiceAccount()).orElse(item));
  }
  public ResourceTemplate buildJmxSecret() {
    return this.jmxSecret!=null ?this.jmxSecret.build():null;
  }
  public A withJmxSecret(ResourceTemplate jmxSecret) {
    _visitables.get("jmxSecret").remove(this.jmxSecret);
    if (jmxSecret!=null){ this.jmxSecret= new ResourceTemplateBuilder(jmxSecret); _visitables.get("jmxSecret").add(this.jmxSecret);} else { this.jmxSecret = null; _visitables.get("jmxSecret").remove(this.jmxSecret); } return (A) this;
  }
  public boolean hasJmxSecret() {
    return this.jmxSecret != null;
  }
  public JmxSecretNested<A> withNewJmxSecret() {
    return new JmxSecretNested(null);
  }
  public JmxSecretNested<A> withNewJmxSecretLike(ResourceTemplate item) {
    return new JmxSecretNested(item);
  }
  public JmxSecretNested<A> editJmxSecret() {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(null));
  }
  public JmxSecretNested<A> editOrNewJmxSecret() {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(new ResourceTemplateBuilder().build()));
  }
  public JmxSecretNested<A> editOrNewJmxSecretLike(ResourceTemplate item) {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaConnectTemplateFluent that = (KafkaConnectTemplateFluent) o;
    if (!java.util.Objects.equals(deployment, that.deployment)) return false;

    if (!java.util.Objects.equals(podSet, that.podSet)) return false;

    if (!java.util.Objects.equals(pod, that.pod)) return false;

    if (!java.util.Objects.equals(buildPod, that.buildPod)) return false;

    if (!java.util.Objects.equals(apiService, that.apiService)) return false;

    if (!java.util.Objects.equals(headlessService, that.headlessService)) return false;

    if (!java.util.Objects.equals(podDisruptionBudget, that.podDisruptionBudget)) return false;

    if (!java.util.Objects.equals(connectContainer, that.connectContainer)) return false;

    if (!java.util.Objects.equals(initContainer, that.initContainer)) return false;

    if (!java.util.Objects.equals(buildContainer, that.buildContainer)) return false;

    if (!java.util.Objects.equals(buildConfig, that.buildConfig)) return false;

    if (!java.util.Objects.equals(clusterRoleBinding, that.clusterRoleBinding)) return false;

    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;

    if (!java.util.Objects.equals(buildServiceAccount, that.buildServiceAccount)) return false;

    if (!java.util.Objects.equals(jmxSecret, that.jmxSecret)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(deployment,  podSet,  pod,  buildPod,  apiService,  headlessService,  podDisruptionBudget,  connectContainer,  initContainer,  buildContainer,  buildConfig,  clusterRoleBinding,  serviceAccount,  buildServiceAccount,  jmxSecret,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (deployment != null) { sb.append("deployment:"); sb.append(deployment + ","); }
    if (podSet != null) { sb.append("podSet:"); sb.append(podSet + ","); }
    if (pod != null) { sb.append("pod:"); sb.append(pod + ","); }
    if (buildPod != null) { sb.append("buildPod:"); sb.append(buildPod + ","); }
    if (apiService != null) { sb.append("apiService:"); sb.append(apiService + ","); }
    if (headlessService != null) { sb.append("headlessService:"); sb.append(headlessService + ","); }
    if (podDisruptionBudget != null) { sb.append("podDisruptionBudget:"); sb.append(podDisruptionBudget + ","); }
    if (connectContainer != null) { sb.append("connectContainer:"); sb.append(connectContainer + ","); }
    if (initContainer != null) { sb.append("initContainer:"); sb.append(initContainer + ","); }
    if (buildContainer != null) { sb.append("buildContainer:"); sb.append(buildContainer + ","); }
    if (buildConfig != null) { sb.append("buildConfig:"); sb.append(buildConfig + ","); }
    if (clusterRoleBinding != null) { sb.append("clusterRoleBinding:"); sb.append(clusterRoleBinding + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (buildServiceAccount != null) { sb.append("buildServiceAccount:"); sb.append(buildServiceAccount + ","); }
    if (jmxSecret != null) { sb.append("jmxSecret:"); sb.append(jmxSecret); }
    sb.append("}");
    return sb.toString();
  }
  public class DeploymentNested<N> extends DeploymentTemplateFluent<DeploymentNested<N>> implements Nested<N>{
    DeploymentNested(DeploymentTemplate item) {
      this.builder = new DeploymentTemplateBuilder(this, item);
    }
    DeploymentTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withDeployment(builder.build());
    }
    public N endDeployment() {
      return and();
    }
    
  }
  public class PodSetNested<N> extends ResourceTemplateFluent<PodSetNested<N>> implements Nested<N>{
    PodSetNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withPodSet(builder.build());
    }
    public N endPodSet() {
      return and();
    }
    
  }
  public class PodNested<N> extends PodTemplateFluent<PodNested<N>> implements Nested<N>{
    PodNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withPod(builder.build());
    }
    public N endPod() {
      return and();
    }
    
  }
  public class BuildPodNested<N> extends PodTemplateFluent<BuildPodNested<N>> implements Nested<N>{
    BuildPodNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withBuildPod(builder.build());
    }
    public N endBuildPod() {
      return and();
    }
    
  }
  public class ApiServiceNested<N> extends InternalServiceTemplateFluent<ApiServiceNested<N>> implements Nested<N>{
    ApiServiceNested(InternalServiceTemplate item) {
      this.builder = new InternalServiceTemplateBuilder(this, item);
    }
    InternalServiceTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withApiService(builder.build());
    }
    public N endApiService() {
      return and();
    }
    
  }
  public class HeadlessServiceNested<N> extends InternalServiceTemplateFluent<HeadlessServiceNested<N>> implements Nested<N>{
    HeadlessServiceNested(InternalServiceTemplate item) {
      this.builder = new InternalServiceTemplateBuilder(this, item);
    }
    InternalServiceTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withHeadlessService(builder.build());
    }
    public N endHeadlessService() {
      return and();
    }
    
  }
  public class PodDisruptionBudgetNested<N> extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>> implements Nested<N>{
    PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
      this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
    }
    PodDisruptionBudgetTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withPodDisruptionBudget(builder.build());
    }
    public N endPodDisruptionBudget() {
      return and();
    }
    
  }
  public class ConnectContainerNested<N> extends ContainerTemplateFluent<ConnectContainerNested<N>> implements Nested<N>{
    ConnectContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withConnectContainer(builder.build());
    }
    public N endConnectContainer() {
      return and();
    }
    
  }
  public class InitContainerNested<N> extends ContainerTemplateFluent<InitContainerNested<N>> implements Nested<N>{
    InitContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withInitContainer(builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  public class BuildContainerNested<N> extends ContainerTemplateFluent<BuildContainerNested<N>> implements Nested<N>{
    BuildContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withBuildContainer(builder.build());
    }
    public N endBuildContainer() {
      return and();
    }
    
  }
  public class BuildConfigNested<N> extends BuildConfigTemplateFluent<BuildConfigNested<N>> implements Nested<N>{
    BuildConfigNested(BuildConfigTemplate item) {
      this.builder = new BuildConfigTemplateBuilder(this, item);
    }
    BuildConfigTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withBuildConfig(builder.build());
    }
    public N endBuildConfig() {
      return and();
    }
    
  }
  public class ClusterRoleBindingNested<N> extends ResourceTemplateFluent<ClusterRoleBindingNested<N>> implements Nested<N>{
    ClusterRoleBindingNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withClusterRoleBinding(builder.build());
    }
    public N endClusterRoleBinding() {
      return and();
    }
    
  }
  public class ServiceAccountNested<N> extends ResourceTemplateFluent<ServiceAccountNested<N>> implements Nested<N>{
    ServiceAccountNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withServiceAccount(builder.build());
    }
    public N endServiceAccount() {
      return and();
    }
    
  }
  public class BuildServiceAccountNested<N> extends ResourceTemplateFluent<BuildServiceAccountNested<N>> implements Nested<N>{
    BuildServiceAccountNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withBuildServiceAccount(builder.build());
    }
    public N endBuildServiceAccount() {
      return and();
    }
    
  }
  public class JmxSecretNested<N> extends ResourceTemplateFluent<JmxSecretNested<N>> implements Nested<N>{
    JmxSecretNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    public N and() {
      return (N) KafkaConnectTemplateFluent.this.withJmxSecret(builder.build());
    }
    public N endJmxSecret() {
      return and();
    }
    
  }
  
}