package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildFluent<A extends BuildFluent<A>> extends BaseFluent<A>{
  public BuildFluent() {
  }
  public BuildFluent(Build instance) {
    instance = (instance != null ? instance : new Build());

    if (instance != null) {
      this.withOutput(instance.getOutput());
      this.withPlugins(instance.getPlugins());
      this.withResources(instance.getResources());
    }
  }
  private VisitableBuilder<? extends Output,?> output;
  private ArrayList<PluginBuilder> plugins;
  private ResourceRequirements resources;
  public Output buildOutput() {
    return this.output!=null?this.output.build():null;
  }
  public A withOutput(Output output) {
    if (output==null){ this.output = null; _visitables.remove("output"); return (A) this;}
    VisitableBuilder<? extends Output,?> builder = builder(output); _visitables.get("output").clear();_visitables.get("output").add(builder);this.output = builder;
    return (A) this;
  }
  public boolean hasOutput() {
    return this.output != null;
  }
  public ImageStreamOutputNested<A> withNewImageStreamOutput() {
    return new ImageStreamOutputNested(null);
  }
  public ImageStreamOutputNested<A> withNewImageStreamOutputLike(ImageStreamOutput item) {
    return new ImageStreamOutputNested(item);
  }
  public DockerOutputNested<A> withNewDockerOutput() {
    return new DockerOutputNested(null);
  }
  public DockerOutputNested<A> withNewDockerOutputLike(DockerOutput item) {
    return new DockerOutputNested(item);
  }
  public A addToPlugins(int index,Plugin item) {
    if (this.plugins == null) {this.plugins = new ArrayList<PluginBuilder>();}
    PluginBuilder builder = new PluginBuilder(item);
    if (index < 0 || index >= plugins.size()) { _visitables.get("plugins").add(builder); plugins.add(builder); } else { _visitables.get("plugins").add(index, builder); plugins.add(index, builder);}
    return (A)this;
  }
  public A setToPlugins(int index,Plugin item) {
    if (this.plugins == null) {this.plugins = new ArrayList<PluginBuilder>();}
    PluginBuilder builder = new PluginBuilder(item);
    if (index < 0 || index >= plugins.size()) { _visitables.get("plugins").add(builder); plugins.add(builder); } else { _visitables.get("plugins").set(index, builder); plugins.set(index, builder);}
    return (A)this;
  }
  public A addToPlugins(io.strimzi.api.kafka.model.connect.build.Plugin... items) {
    if (this.plugins == null) {this.plugins = new ArrayList<PluginBuilder>();}
    for (Plugin item : items) {PluginBuilder builder = new PluginBuilder(item);_visitables.get("plugins").add(builder);this.plugins.add(builder);} return (A)this;
  }
  public A addAllToPlugins(Collection<Plugin> items) {
    if (this.plugins == null) {this.plugins = new ArrayList<PluginBuilder>();}
    for (Plugin item : items) {PluginBuilder builder = new PluginBuilder(item);_visitables.get("plugins").add(builder);this.plugins.add(builder);} return (A)this;
  }
  public A removeFromPlugins(io.strimzi.api.kafka.model.connect.build.Plugin... items) {
    if (this.plugins == null) return (A)this;
    for (Plugin item : items) {PluginBuilder builder = new PluginBuilder(item);_visitables.get("plugins").remove(builder); this.plugins.remove(builder);} return (A)this;
  }
  public A removeAllFromPlugins(Collection<Plugin> items) {
    if (this.plugins == null) return (A)this;
    for (Plugin item : items) {PluginBuilder builder = new PluginBuilder(item);_visitables.get("plugins").remove(builder); this.plugins.remove(builder);} return (A)this;
  }
  public A removeMatchingFromPlugins(Predicate<PluginBuilder> predicate) {
    if (plugins == null) return (A) this;
    final Iterator<PluginBuilder> each = plugins.iterator();
    final List visitables = _visitables.get("plugins");
    while (each.hasNext()) {
      PluginBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Plugin> buildPlugins() {
    return plugins != null ? build(plugins) : null;
  }
  public Plugin buildPlugin(int index) {
    return this.plugins.get(index).build();
  }
  public Plugin buildFirstPlugin() {
    return this.plugins.get(0).build();
  }
  public Plugin buildLastPlugin() {
    return this.plugins.get(plugins.size() - 1).build();
  }
  public Plugin buildMatchingPlugin(Predicate<PluginBuilder> predicate) {
    for (PluginBuilder item: plugins) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingPlugin(Predicate<PluginBuilder> predicate) {
    for (PluginBuilder item: plugins) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPlugins(List<Plugin> plugins) {
    if (this.plugins != null) { _visitables.get("plugins").clear();}
    if (plugins != null) {this.plugins = new ArrayList(); for (Plugin item : plugins){this.addToPlugins(item);}} else { this.plugins = null;} return (A) this;
  }
  public A withPlugins(io.strimzi.api.kafka.model.connect.build.Plugin... plugins) {
    if (this.plugins != null) {this.plugins.clear(); _visitables.remove("plugins"); }
    if (plugins != null) {for (Plugin item :plugins){ this.addToPlugins(item);}} return (A) this;
  }
  public boolean hasPlugins() {
    return plugins != null && !plugins.isEmpty();
  }
  public PluginsNested<A> addNewPlugin() {
    return new PluginsNested(-1, null);
  }
  public PluginsNested<A> addNewPluginLike(Plugin item) {
    return new PluginsNested(-1, item);
  }
  public PluginsNested<A> setNewPluginLike(int index,Plugin item) {
    return new PluginsNested(index, item);
  }
  public PluginsNested<A> editPlugin(int index) {
    if (plugins.size() <= index) throw new RuntimeException("Can't edit plugins. Index exceeds size.");
    return setNewPluginLike(index, buildPlugin(index));
  }
  public PluginsNested<A> editFirstPlugin() {
    if (plugins.size() == 0) throw new RuntimeException("Can't edit first plugins. The list is empty.");
    return setNewPluginLike(0, buildPlugin(0));
  }
  public PluginsNested<A> editLastPlugin() {
    int index = plugins.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last plugins. The list is empty.");
    return setNewPluginLike(index, buildPlugin(index));
  }
  public PluginsNested<A> editMatchingPlugin(Predicate<PluginBuilder> predicate) {
    int index = -1;
    for (int i=0;i<plugins.size();i++) { 
    if (predicate.test(plugins.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching plugins. No match found.");
    return setNewPluginLike(index, buildPlugin(index));
  }
  public ResourceRequirements getResources() {
    return this.resources;
  }
  public A withResources(ResourceRequirements resources) {
    this.resources=resources; return (A) this;
  }
  public boolean hasResources() {
    return this.resources != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildFluent that = (BuildFluent) o;
    if (!java.util.Objects.equals(output, that.output)) return false;

    if (!java.util.Objects.equals(plugins, that.plugins)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(output,  plugins,  resources,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (output != null) { sb.append("output:"); sb.append(output + ","); }
    if (plugins != null && !plugins.isEmpty()) { sb.append("plugins:"); sb.append(plugins + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.connect.build."+"ImageStreamOutput": return (VisitableBuilder<T, ?>)new ImageStreamOutputBuilder((ImageStreamOutput) item);
    case "io.strimzi.api.kafka.model.connect.build."+"DockerOutput": return (VisitableBuilder<T, ?>)new DockerOutputBuilder((DockerOutput) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class ImageStreamOutputNested<N> extends ImageStreamOutputFluent<ImageStreamOutputNested<N>> implements Nested<N>{
    ImageStreamOutputNested(ImageStreamOutput item) {
      this.builder = new ImageStreamOutputBuilder(this, item);
    }
    ImageStreamOutputBuilder builder;
    public N and() {
      return (N) BuildFluent.this.withOutput(builder.build());
    }
    public N endImageStreamOutput() {
      return and();
    }
    
  }
  public class DockerOutputNested<N> extends DockerOutputFluent<DockerOutputNested<N>> implements Nested<N>{
    DockerOutputNested(DockerOutput item) {
      this.builder = new DockerOutputBuilder(this, item);
    }
    DockerOutputBuilder builder;
    public N and() {
      return (N) BuildFluent.this.withOutput(builder.build());
    }
    public N endDockerOutput() {
      return and();
    }
    
  }
  public class PluginsNested<N> extends PluginFluent<PluginsNested<N>> implements Nested<N>{
    PluginsNested(int index,Plugin item) {
      this.index = index;
      this.builder = new PluginBuilder(this, item);
    }
    PluginBuilder builder;
    int index;
    public N and() {
      return (N) BuildFluent.this.setToPlugins(index,builder.build());
    }
    public N endPlugin() {
      return and();
    }
    
  }
  
}