package io.strimzi.api.kafka.model.connect.build;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DockerOutputFluent<A extends DockerOutputFluent<A>> extends BaseFluent<A>{
  public DockerOutputFluent() {
  }
  public DockerOutputFluent(DockerOutput instance) {
    instance = (instance != null ? instance : new DockerOutput());

    if (instance != null) {
      this.withPushSecret(instance.getPushSecret());
      this.withAdditionalKanikoOptions(instance.getAdditionalKanikoOptions());
      this.withImage(instance.getImage());
    }
  }
  private String pushSecret;
  private List<String> additionalKanikoOptions;
  private String image;
  public String getPushSecret() {
    return this.pushSecret;
  }
  public A withPushSecret(String pushSecret) {
    this.pushSecret=pushSecret; return (A) this;
  }
  public boolean hasPushSecret() {
    return this.pushSecret != null;
  }
  public A addToAdditionalKanikoOptions(int index,String item) {
    if (this.additionalKanikoOptions == null) {this.additionalKanikoOptions = new ArrayList<String>();}
    this.additionalKanikoOptions.add(index, item);
    return (A)this;
  }
  public A setToAdditionalKanikoOptions(int index,String item) {
    if (this.additionalKanikoOptions == null) {this.additionalKanikoOptions = new ArrayList<String>();}
    this.additionalKanikoOptions.set(index, item); return (A)this;
  }
  public A addToAdditionalKanikoOptions(java.lang.String... items) {
    if (this.additionalKanikoOptions == null) {this.additionalKanikoOptions = new ArrayList<String>();}
    for (String item : items) {this.additionalKanikoOptions.add(item);} return (A)this;
  }
  public A addAllToAdditionalKanikoOptions(Collection<String> items) {
    if (this.additionalKanikoOptions == null) {this.additionalKanikoOptions = new ArrayList<String>();}
    for (String item : items) {this.additionalKanikoOptions.add(item);} return (A)this;
  }
  public A removeFromAdditionalKanikoOptions(java.lang.String... items) {
    if (this.additionalKanikoOptions == null) return (A)this;
    for (String item : items) { this.additionalKanikoOptions.remove(item);} return (A)this;
  }
  public A removeAllFromAdditionalKanikoOptions(Collection<String> items) {
    if (this.additionalKanikoOptions == null) return (A)this;
    for (String item : items) { this.additionalKanikoOptions.remove(item);} return (A)this;
  }
  public List<String> getAdditionalKanikoOptions() {
    return this.additionalKanikoOptions;
  }
  public String getAdditionalKanikoOption(int index) {
    return this.additionalKanikoOptions.get(index);
  }
  public String getFirstAdditionalKanikoOption() {
    return this.additionalKanikoOptions.get(0);
  }
  public String getLastAdditionalKanikoOption() {
    return this.additionalKanikoOptions.get(additionalKanikoOptions.size() - 1);
  }
  public String getMatchingAdditionalKanikoOption(Predicate<String> predicate) {
    for (String item: additionalKanikoOptions) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingAdditionalKanikoOption(Predicate<String> predicate) {
    for (String item: additionalKanikoOptions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalKanikoOptions(List<String> additionalKanikoOptions) {
    if (additionalKanikoOptions != null) {this.additionalKanikoOptions = new ArrayList(); for (String item : additionalKanikoOptions){this.addToAdditionalKanikoOptions(item);}} else { this.additionalKanikoOptions = null;} return (A) this;
  }
  public A withAdditionalKanikoOptions(java.lang.String... additionalKanikoOptions) {
    if (this.additionalKanikoOptions != null) {this.additionalKanikoOptions.clear(); _visitables.remove("additionalKanikoOptions"); }
    if (additionalKanikoOptions != null) {for (String item :additionalKanikoOptions){ this.addToAdditionalKanikoOptions(item);}} return (A) this;
  }
  public boolean hasAdditionalKanikoOptions() {
    return additionalKanikoOptions != null && !additionalKanikoOptions.isEmpty();
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public boolean hasImage() {
    return this.image != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DockerOutputFluent that = (DockerOutputFluent) o;
    if (!java.util.Objects.equals(pushSecret, that.pushSecret)) return false;

    if (!java.util.Objects.equals(additionalKanikoOptions, that.additionalKanikoOptions)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(pushSecret,  additionalKanikoOptions,  image,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (pushSecret != null) { sb.append("pushSecret:"); sb.append(pushSecret + ","); }
    if (additionalKanikoOptions != null && !additionalKanikoOptions.isEmpty()) { sb.append("additionalKanikoOptions:"); sb.append(additionalKanikoOptions + ","); }
    if (image != null) { sb.append("image:"); sb.append(image); }
    sb.append("}");
    return sb.toString();
  }
  
}