package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PluginFluent<A extends PluginFluent<A>> extends BaseFluent<A>{
  public PluginFluent() {
  }
  public PluginFluent(Plugin instance) {
    instance = (instance != null ? instance : new Plugin());

    if (instance != null) {
      this.withName(instance.getName());
      this.withArtifacts(instance.getArtifacts());
    }
  }
  private String name;
  private ArrayList<VisitableBuilder<? extends Artifact,?>> artifacts;
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public A addToArtifacts(VisitableBuilder<? extends Artifact,?> builder) {
    if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
    _visitables.get("artifacts").add(builder);this.artifacts.add(builder); return (A)this;
  }
  public A addToArtifacts(int index,VisitableBuilder<? extends Artifact,?> builder) {
    if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
    if (index < 0 || index >= artifacts.size()) { _visitables.get("artifacts").add(builder); artifacts.add(builder); } else { _visitables.get("artifacts").add(index, builder); artifacts.add(index, builder);}
    return (A)this;
  }
  public A addToArtifacts(int index,Artifact item) {
    if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
    VisitableBuilder<? extends Artifact,?> builder = builder(item);
    if (index < 0 || index >= artifacts.size()) { _visitables.get("artifacts").add(builder); artifacts.add(builder); } else { _visitables.get("artifacts").add(index, builder); artifacts.add(index, builder);}
    return (A)this;
  }
  public A setToArtifacts(int index,Artifact item) {
    if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
    VisitableBuilder<? extends Artifact,?> builder = builder(item);
    if (index < 0 || index >= artifacts.size()) { _visitables.get("artifacts").add(builder); artifacts.add(builder); } else { _visitables.get("artifacts").set(index, builder); artifacts.set(index, builder);}
    return (A)this;
  }
  public A addToArtifacts(io.strimzi.api.kafka.model.connect.build.Artifact... items) {
    if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
    for (Artifact item : items) { VisitableBuilder<? extends Artifact,?> builder = builder(item); _visitables.get("artifacts").add(builder);this.artifacts.add(builder); }
    return (A)this;
  }
  public A addAllToArtifacts(Collection<Artifact> items) {
    if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
    for (Artifact item : items) { VisitableBuilder<? extends Artifact,?> builder = builder(item); _visitables.get("artifacts").add(builder);this.artifacts.add(builder); }
    return (A)this;
  }
  public A removeFromArtifacts(VisitableBuilder<? extends Artifact,?> builder) {
    if (this.artifacts == null) return (A)this;
    _visitables.get("artifacts").remove(builder);this.artifacts.remove(builder); return (A)this;
  }
  public A removeFromArtifacts(io.strimzi.api.kafka.model.connect.build.Artifact... items) {
    if (this.artifacts == null) return (A)this;
    for (Artifact item : items) {
    VisitableBuilder<? extends Artifact,?> builder = builder(item); _visitables.get("artifacts").remove(builder);this.artifacts.remove(builder);
    } return (A)this;
  }
  public A removeAllFromArtifacts(Collection<Artifact> items) {
    if (this.artifacts == null) return (A)this;
    for (Artifact item : items) {
    VisitableBuilder<? extends Artifact,?> builder = builder(item); _visitables.get("artifacts").remove(builder);this.artifacts.remove(builder);
    } return (A)this;
  }
  public A removeMatchingFromArtifacts(Predicate<VisitableBuilder<? extends Artifact,?>> predicate) {
    if (artifacts == null) return (A) this;
    final Iterator<VisitableBuilder<? extends Artifact,?>> each = artifacts.iterator();
    final List visitables = _visitables.get("artifacts");
    while (each.hasNext()) {
      VisitableBuilder<? extends Artifact,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Artifact> buildArtifacts() {
    return build(artifacts);
  }
  public Artifact buildArtifact(int index) {
    return this.artifacts.get(index).build();
  }
  public Artifact buildFirstArtifact() {
    return this.artifacts.get(0).build();
  }
  public Artifact buildLastArtifact() {
    return this.artifacts.get(artifacts.size() - 1).build();
  }
  public Artifact buildMatchingArtifact(Predicate<VisitableBuilder<? extends Artifact,?>> predicate) {
    for (VisitableBuilder<? extends Artifact,?> item: artifacts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingArtifact(Predicate<VisitableBuilder<? extends Artifact,?>> predicate) {
    for (VisitableBuilder<? extends Artifact,?> item: artifacts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withArtifacts(List<Artifact> artifacts) {
    if (artifacts != null) {this.artifacts = new ArrayList(); for (Artifact item : artifacts){this.addToArtifacts(item);}} else { this.artifacts = null;} return (A) this;
  }
  public A withArtifacts(io.strimzi.api.kafka.model.connect.build.Artifact... artifacts) {
    if (this.artifacts != null) {this.artifacts.clear(); _visitables.remove("artifacts"); }
    if (artifacts != null) {for (Artifact item :artifacts){ this.addToArtifacts(item);}} return (A) this;
  }
  public boolean hasArtifacts() {
    return artifacts != null && !artifacts.isEmpty();
  }
  public MavenArtifactArtifactsNested<A> addNewMavenArtifactArtifact() {
    return new MavenArtifactArtifactsNested(-1, null);
  }
  public MavenArtifactArtifactsNested<A> addNewMavenArtifactArtifactLike(MavenArtifact item) {
    return new MavenArtifactArtifactsNested(-1, item);
  }
  public MavenArtifactArtifactsNested<A> setNewMavenArtifactArtifactLike(int index,MavenArtifact item) {
    return new MavenArtifactArtifactsNested(index, item);
  }
  public ZipArtifactArtifactsNested<A> addNewZipArtifactArtifact() {
    return new ZipArtifactArtifactsNested(-1, null);
  }
  public ZipArtifactArtifactsNested<A> addNewZipArtifactArtifactLike(ZipArtifact item) {
    return new ZipArtifactArtifactsNested(-1, item);
  }
  public ZipArtifactArtifactsNested<A> setNewZipArtifactArtifactLike(int index,ZipArtifact item) {
    return new ZipArtifactArtifactsNested(index, item);
  }
  public OtherArtifactArtifactsNested<A> addNewOtherArtifactArtifact() {
    return new OtherArtifactArtifactsNested(-1, null);
  }
  public OtherArtifactArtifactsNested<A> addNewOtherArtifactArtifactLike(OtherArtifact item) {
    return new OtherArtifactArtifactsNested(-1, item);
  }
  public OtherArtifactArtifactsNested<A> setNewOtherArtifactArtifactLike(int index,OtherArtifact item) {
    return new OtherArtifactArtifactsNested(index, item);
  }
  public JarArtifactArtifactsNested<A> addNewJarArtifactArtifact() {
    return new JarArtifactArtifactsNested(-1, null);
  }
  public JarArtifactArtifactsNested<A> addNewJarArtifactArtifactLike(JarArtifact item) {
    return new JarArtifactArtifactsNested(-1, item);
  }
  public JarArtifactArtifactsNested<A> setNewJarArtifactArtifactLike(int index,JarArtifact item) {
    return new JarArtifactArtifactsNested(index, item);
  }
  public TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifact() {
    return new TgzArtifactArtifactsNested(-1, null);
  }
  public TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifactLike(TgzArtifact item) {
    return new TgzArtifactArtifactsNested(-1, item);
  }
  public TgzArtifactArtifactsNested<A> setNewTgzArtifactArtifactLike(int index,TgzArtifact item) {
    return new TgzArtifactArtifactsNested(index, item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PluginFluent that = (PluginFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(artifacts, that.artifacts)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(name,  artifacts,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (artifacts != null && !artifacts.isEmpty()) { sb.append("artifacts:"); sb.append(artifacts); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.connect.build."+"MavenArtifact": return (VisitableBuilder<T, ?>)new MavenArtifactBuilder((MavenArtifact) item);
    case "io.strimzi.api.kafka.model.connect.build."+"ZipArtifact": return (VisitableBuilder<T, ?>)new ZipArtifactBuilder((ZipArtifact) item);
    case "io.strimzi.api.kafka.model.connect.build."+"OtherArtifact": return (VisitableBuilder<T, ?>)new OtherArtifactBuilder((OtherArtifact) item);
    case "io.strimzi.api.kafka.model.connect.build."+"JarArtifact": return (VisitableBuilder<T, ?>)new JarArtifactBuilder((JarArtifact) item);
    case "io.strimzi.api.kafka.model.connect.build."+"TgzArtifact": return (VisitableBuilder<T, ?>)new TgzArtifactBuilder((TgzArtifact) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class MavenArtifactArtifactsNested<N> extends MavenArtifactFluent<MavenArtifactArtifactsNested<N>> implements Nested<N>{
    MavenArtifactArtifactsNested(int index,MavenArtifact item) {
      this.index = index;
      this.builder = new MavenArtifactBuilder(this, item);
    }
    MavenArtifactBuilder builder;
    int index;
    public N and() {
      return (N) PluginFluent.this.setToArtifacts(index,builder.build());
    }
    public N endMavenArtifactArtifact() {
      return and();
    }
    
  }
  public class ZipArtifactArtifactsNested<N> extends ZipArtifactFluent<ZipArtifactArtifactsNested<N>> implements Nested<N>{
    ZipArtifactArtifactsNested(int index,ZipArtifact item) {
      this.index = index;
      this.builder = new ZipArtifactBuilder(this, item);
    }
    ZipArtifactBuilder builder;
    int index;
    public N and() {
      return (N) PluginFluent.this.setToArtifacts(index,builder.build());
    }
    public N endZipArtifactArtifact() {
      return and();
    }
    
  }
  public class OtherArtifactArtifactsNested<N> extends OtherArtifactFluent<OtherArtifactArtifactsNested<N>> implements Nested<N>{
    OtherArtifactArtifactsNested(int index,OtherArtifact item) {
      this.index = index;
      this.builder = new OtherArtifactBuilder(this, item);
    }
    OtherArtifactBuilder builder;
    int index;
    public N and() {
      return (N) PluginFluent.this.setToArtifacts(index,builder.build());
    }
    public N endOtherArtifactArtifact() {
      return and();
    }
    
  }
  public class JarArtifactArtifactsNested<N> extends JarArtifactFluent<JarArtifactArtifactsNested<N>> implements Nested<N>{
    JarArtifactArtifactsNested(int index,JarArtifact item) {
      this.index = index;
      this.builder = new JarArtifactBuilder(this, item);
    }
    JarArtifactBuilder builder;
    int index;
    public N and() {
      return (N) PluginFluent.this.setToArtifacts(index,builder.build());
    }
    public N endJarArtifactArtifact() {
      return and();
    }
    
  }
  public class TgzArtifactArtifactsNested<N> extends TgzArtifactFluent<TgzArtifactArtifactsNested<N>> implements Nested<N>{
    TgzArtifactArtifactsNested(int index,TgzArtifact item) {
      this.index = index;
      this.builder = new TgzArtifactBuilder(this, item);
    }
    TgzArtifactBuilder builder;
    int index;
    public N and() {
      return (N) PluginFluent.this.setToArtifacts(index,builder.build());
    }
    public N endTgzArtifactArtifact() {
      return and();
    }
    
  }
  
}