package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TgzArtifactBuilder extends TgzArtifactFluent<TgzArtifactBuilder> implements VisitableBuilder<TgzArtifact,TgzArtifactBuilder>{
  public TgzArtifactBuilder() {
    this(false);
  }
  public TgzArtifactBuilder(Boolean validationEnabled) {
    this(new TgzArtifact(), validationEnabled);
  }
  public TgzArtifactBuilder(TgzArtifactFluent<?> fluent) {
    this(fluent, false);
  }
  public TgzArtifactBuilder(TgzArtifactFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TgzArtifact(), validationEnabled);
  }
  public TgzArtifactBuilder(TgzArtifactFluent<?> fluent,TgzArtifact instance) {
    this(fluent, instance, false);
  }
  public TgzArtifactBuilder(TgzArtifactFluent<?> fluent,TgzArtifact instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TgzArtifact());

    if (instance != null) {
      fluent.withUrl(instance.getUrl());
      fluent.withSha512sum(instance.getSha512sum());
      fluent.withInsecure(instance.getInsecure());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TgzArtifactBuilder(TgzArtifact instance) {
    this(instance,false);
  }
  public TgzArtifactBuilder(TgzArtifact instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TgzArtifact());

    if (instance != null) {
      this.withUrl(instance.getUrl());
      this.withSha512sum(instance.getSha512sum());
      this.withInsecure(instance.getInsecure());
    }
    this.validationEnabled = validationEnabled; 
  }
  TgzArtifactFluent<?> fluent;
  Boolean validationEnabled;
  public TgzArtifact build() {
    TgzArtifact buildable = new TgzArtifact();
    buildable.setUrl(fluent.getUrl());
    buildable.setSha512sum(fluent.getSha512sum());
    buildable.setInsecure(fluent.getInsecure());
    return buildable;
  }
  
}