package io.strimzi.api.kafka.model.connector;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaConnectorBuilder extends KafkaConnectorFluent<KafkaConnectorBuilder> implements VisitableBuilder<KafkaConnector,KafkaConnectorBuilder>{
  public KafkaConnectorBuilder() {
    this(false);
  }
  public KafkaConnectorBuilder(Boolean validationEnabled) {
    this(new KafkaConnector(), validationEnabled);
  }
  public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaConnector(), validationEnabled);
  }
  public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent,KafkaConnector instance) {
    this(fluent, instance, false);
  }
  public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent,KafkaConnector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaConnector());

    if (instance != null) {
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaConnectorBuilder(KafkaConnector instance) {
    this(instance,false);
  }
  public KafkaConnectorBuilder(KafkaConnector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaConnector());

    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaConnectorFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaConnector build() {
    KafkaConnector buildable = new KafkaConnector(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  
}