package io.strimzi.api.kafka.model.jmxtrans;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.strimzi.api.kafka.model.common.template.JmxTransTemplateFluent;
import io.strimzi.api.kafka.model.common.template.JmxTransTemplateBuilder;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.template.JmxTransTemplate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JmxTransSpecFluent<A extends JmxTransSpecFluent<A>> extends BaseFluent<A>{
  public JmxTransSpecFluent() {
  }
  public JmxTransSpecFluent(JmxTransSpec instance) {
    instance = (instance != null ? instance : new JmxTransSpec());

    if (instance != null) {
      this.withImage(instance.getImage());
      this.withLogLevel(instance.getLogLevel());
      this.withOutputDefinitions(instance.getOutputDefinitions());
      this.withKafkaQueries(instance.getKafkaQueries());
      this.withResources(instance.getResources());
      this.withTemplate(instance.getTemplate());
    }
  }
  private String image;
  private String logLevel;
  private ArrayList<JmxTransOutputDefinitionTemplateBuilder> outputDefinitions;
  private ArrayList<JmxTransQueryTemplateBuilder> kafkaQueries;
  private ResourceRequirements resources;
  private JmxTransTemplateBuilder template;
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public boolean hasImage() {
    return this.image != null;
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public A addToOutputDefinitions(int index,JmxTransOutputDefinitionTemplate item) {
    if (this.outputDefinitions == null) {this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();}
    JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
    if (index < 0 || index >= outputDefinitions.size()) { _visitables.get("outputDefinitions").add(builder); outputDefinitions.add(builder); } else { _visitables.get("outputDefinitions").add(index, builder); outputDefinitions.add(index, builder);}
    return (A)this;
  }
  public A setToOutputDefinitions(int index,JmxTransOutputDefinitionTemplate item) {
    if (this.outputDefinitions == null) {this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();}
    JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);
    if (index < 0 || index >= outputDefinitions.size()) { _visitables.get("outputDefinitions").add(builder); outputDefinitions.add(builder); } else { _visitables.get("outputDefinitions").set(index, builder); outputDefinitions.set(index, builder);}
    return (A)this;
  }
  public A addToOutputDefinitions(io.strimzi.api.kafka.model.jmxtrans.JmxTransOutputDefinitionTemplate... items) {
    if (this.outputDefinitions == null) {this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();}
    for (JmxTransOutputDefinitionTemplate item : items) {JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").add(builder);this.outputDefinitions.add(builder);} return (A)this;
  }
  public A addAllToOutputDefinitions(Collection<JmxTransOutputDefinitionTemplate> items) {
    if (this.outputDefinitions == null) {this.outputDefinitions = new ArrayList<JmxTransOutputDefinitionTemplateBuilder>();}
    for (JmxTransOutputDefinitionTemplate item : items) {JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").add(builder);this.outputDefinitions.add(builder);} return (A)this;
  }
  public A removeFromOutputDefinitions(io.strimzi.api.kafka.model.jmxtrans.JmxTransOutputDefinitionTemplate... items) {
    if (this.outputDefinitions == null) return (A)this;
    for (JmxTransOutputDefinitionTemplate item : items) {JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").remove(builder); this.outputDefinitions.remove(builder);} return (A)this;
  }
  public A removeAllFromOutputDefinitions(Collection<JmxTransOutputDefinitionTemplate> items) {
    if (this.outputDefinitions == null) return (A)this;
    for (JmxTransOutputDefinitionTemplate item : items) {JmxTransOutputDefinitionTemplateBuilder builder = new JmxTransOutputDefinitionTemplateBuilder(item);_visitables.get("outputDefinitions").remove(builder); this.outputDefinitions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromOutputDefinitions(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
    if (outputDefinitions == null) return (A) this;
    final Iterator<JmxTransOutputDefinitionTemplateBuilder> each = outputDefinitions.iterator();
    final List visitables = _visitables.get("outputDefinitions");
    while (each.hasNext()) {
      JmxTransOutputDefinitionTemplateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<JmxTransOutputDefinitionTemplate> buildOutputDefinitions() {
    return outputDefinitions != null ? build(outputDefinitions) : null;
  }
  public JmxTransOutputDefinitionTemplate buildOutputDefinition(int index) {
    return this.outputDefinitions.get(index).build();
  }
  public JmxTransOutputDefinitionTemplate buildFirstOutputDefinition() {
    return this.outputDefinitions.get(0).build();
  }
  public JmxTransOutputDefinitionTemplate buildLastOutputDefinition() {
    return this.outputDefinitions.get(outputDefinitions.size() - 1).build();
  }
  public JmxTransOutputDefinitionTemplate buildMatchingOutputDefinition(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
    for (JmxTransOutputDefinitionTemplateBuilder item: outputDefinitions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingOutputDefinition(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
    for (JmxTransOutputDefinitionTemplateBuilder item: outputDefinitions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOutputDefinitions(List<JmxTransOutputDefinitionTemplate> outputDefinitions) {
    if (this.outputDefinitions != null) { _visitables.get("outputDefinitions").clear();}
    if (outputDefinitions != null) {this.outputDefinitions = new ArrayList(); for (JmxTransOutputDefinitionTemplate item : outputDefinitions){this.addToOutputDefinitions(item);}} else { this.outputDefinitions = null;} return (A) this;
  }
  public A withOutputDefinitions(io.strimzi.api.kafka.model.jmxtrans.JmxTransOutputDefinitionTemplate... outputDefinitions) {
    if (this.outputDefinitions != null) {this.outputDefinitions.clear(); _visitables.remove("outputDefinitions"); }
    if (outputDefinitions != null) {for (JmxTransOutputDefinitionTemplate item :outputDefinitions){ this.addToOutputDefinitions(item);}} return (A) this;
  }
  public boolean hasOutputDefinitions() {
    return outputDefinitions != null && !outputDefinitions.isEmpty();
  }
  public OutputDefinitionsNested<A> addNewOutputDefinition() {
    return new OutputDefinitionsNested(-1, null);
  }
  public OutputDefinitionsNested<A> addNewOutputDefinitionLike(JmxTransOutputDefinitionTemplate item) {
    return new OutputDefinitionsNested(-1, item);
  }
  public OutputDefinitionsNested<A> setNewOutputDefinitionLike(int index,JmxTransOutputDefinitionTemplate item) {
    return new OutputDefinitionsNested(index, item);
  }
  public OutputDefinitionsNested<A> editOutputDefinition(int index) {
    if (outputDefinitions.size() <= index) throw new RuntimeException("Can't edit outputDefinitions. Index exceeds size.");
    return setNewOutputDefinitionLike(index, buildOutputDefinition(index));
  }
  public OutputDefinitionsNested<A> editFirstOutputDefinition() {
    if (outputDefinitions.size() == 0) throw new RuntimeException("Can't edit first outputDefinitions. The list is empty.");
    return setNewOutputDefinitionLike(0, buildOutputDefinition(0));
  }
  public OutputDefinitionsNested<A> editLastOutputDefinition() {
    int index = outputDefinitions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last outputDefinitions. The list is empty.");
    return setNewOutputDefinitionLike(index, buildOutputDefinition(index));
  }
  public OutputDefinitionsNested<A> editMatchingOutputDefinition(Predicate<JmxTransOutputDefinitionTemplateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<outputDefinitions.size();i++) { 
    if (predicate.test(outputDefinitions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching outputDefinitions. No match found.");
    return setNewOutputDefinitionLike(index, buildOutputDefinition(index));
  }
  public A addToKafkaQueries(int index,JmxTransQueryTemplate item) {
    if (this.kafkaQueries == null) {this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();}
    JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
    if (index < 0 || index >= kafkaQueries.size()) { _visitables.get("kafkaQueries").add(builder); kafkaQueries.add(builder); } else { _visitables.get("kafkaQueries").add(index, builder); kafkaQueries.add(index, builder);}
    return (A)this;
  }
  public A setToKafkaQueries(int index,JmxTransQueryTemplate item) {
    if (this.kafkaQueries == null) {this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();}
    JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);
    if (index < 0 || index >= kafkaQueries.size()) { _visitables.get("kafkaQueries").add(builder); kafkaQueries.add(builder); } else { _visitables.get("kafkaQueries").set(index, builder); kafkaQueries.set(index, builder);}
    return (A)this;
  }
  public A addToKafkaQueries(io.strimzi.api.kafka.model.jmxtrans.JmxTransQueryTemplate... items) {
    if (this.kafkaQueries == null) {this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();}
    for (JmxTransQueryTemplate item : items) {JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").add(builder);this.kafkaQueries.add(builder);} return (A)this;
  }
  public A addAllToKafkaQueries(Collection<JmxTransQueryTemplate> items) {
    if (this.kafkaQueries == null) {this.kafkaQueries = new ArrayList<JmxTransQueryTemplateBuilder>();}
    for (JmxTransQueryTemplate item : items) {JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").add(builder);this.kafkaQueries.add(builder);} return (A)this;
  }
  public A removeFromKafkaQueries(io.strimzi.api.kafka.model.jmxtrans.JmxTransQueryTemplate... items) {
    if (this.kafkaQueries == null) return (A)this;
    for (JmxTransQueryTemplate item : items) {JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").remove(builder); this.kafkaQueries.remove(builder);} return (A)this;
  }
  public A removeAllFromKafkaQueries(Collection<JmxTransQueryTemplate> items) {
    if (this.kafkaQueries == null) return (A)this;
    for (JmxTransQueryTemplate item : items) {JmxTransQueryTemplateBuilder builder = new JmxTransQueryTemplateBuilder(item);_visitables.get("kafkaQueries").remove(builder); this.kafkaQueries.remove(builder);} return (A)this;
  }
  public A removeMatchingFromKafkaQueries(Predicate<JmxTransQueryTemplateBuilder> predicate) {
    if (kafkaQueries == null) return (A) this;
    final Iterator<JmxTransQueryTemplateBuilder> each = kafkaQueries.iterator();
    final List visitables = _visitables.get("kafkaQueries");
    while (each.hasNext()) {
      JmxTransQueryTemplateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<JmxTransQueryTemplate> buildKafkaQueries() {
    return kafkaQueries != null ? build(kafkaQueries) : null;
  }
  public JmxTransQueryTemplate buildKafkaQuery(int index) {
    return this.kafkaQueries.get(index).build();
  }
  public JmxTransQueryTemplate buildFirstKafkaQuery() {
    return this.kafkaQueries.get(0).build();
  }
  public JmxTransQueryTemplate buildLastKafkaQuery() {
    return this.kafkaQueries.get(kafkaQueries.size() - 1).build();
  }
  public JmxTransQueryTemplate buildMatchingKafkaQuery(Predicate<JmxTransQueryTemplateBuilder> predicate) {
    for (JmxTransQueryTemplateBuilder item: kafkaQueries) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingKafkaQuery(Predicate<JmxTransQueryTemplateBuilder> predicate) {
    for (JmxTransQueryTemplateBuilder item: kafkaQueries) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withKafkaQueries(List<JmxTransQueryTemplate> kafkaQueries) {
    if (this.kafkaQueries != null) { _visitables.get("kafkaQueries").clear();}
    if (kafkaQueries != null) {this.kafkaQueries = new ArrayList(); for (JmxTransQueryTemplate item : kafkaQueries){this.addToKafkaQueries(item);}} else { this.kafkaQueries = null;} return (A) this;
  }
  public A withKafkaQueries(io.strimzi.api.kafka.model.jmxtrans.JmxTransQueryTemplate... kafkaQueries) {
    if (this.kafkaQueries != null) {this.kafkaQueries.clear(); _visitables.remove("kafkaQueries"); }
    if (kafkaQueries != null) {for (JmxTransQueryTemplate item :kafkaQueries){ this.addToKafkaQueries(item);}} return (A) this;
  }
  public boolean hasKafkaQueries() {
    return kafkaQueries != null && !kafkaQueries.isEmpty();
  }
  public KafkaQueriesNested<A> addNewKafkaQuery() {
    return new KafkaQueriesNested(-1, null);
  }
  public KafkaQueriesNested<A> addNewKafkaQueryLike(JmxTransQueryTemplate item) {
    return new KafkaQueriesNested(-1, item);
  }
  public KafkaQueriesNested<A> setNewKafkaQueryLike(int index,JmxTransQueryTemplate item) {
    return new KafkaQueriesNested(index, item);
  }
  public KafkaQueriesNested<A> editKafkaQuery(int index) {
    if (kafkaQueries.size() <= index) throw new RuntimeException("Can't edit kafkaQueries. Index exceeds size.");
    return setNewKafkaQueryLike(index, buildKafkaQuery(index));
  }
  public KafkaQueriesNested<A> editFirstKafkaQuery() {
    if (kafkaQueries.size() == 0) throw new RuntimeException("Can't edit first kafkaQueries. The list is empty.");
    return setNewKafkaQueryLike(0, buildKafkaQuery(0));
  }
  public KafkaQueriesNested<A> editLastKafkaQuery() {
    int index = kafkaQueries.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last kafkaQueries. The list is empty.");
    return setNewKafkaQueryLike(index, buildKafkaQuery(index));
  }
  public KafkaQueriesNested<A> editMatchingKafkaQuery(Predicate<JmxTransQueryTemplateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<kafkaQueries.size();i++) { 
    if (predicate.test(kafkaQueries.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching kafkaQueries. No match found.");
    return setNewKafkaQueryLike(index, buildKafkaQuery(index));
  }
  public ResourceRequirements getResources() {
    return this.resources;
  }
  public A withResources(ResourceRequirements resources) {
    this.resources=resources; return (A) this;
  }
  public boolean hasResources() {
    return this.resources != null;
  }
  public JmxTransTemplate buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(JmxTransTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new JmxTransTemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public boolean hasTemplate() {
    return this.template != null;
  }
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  public TemplateNested<A> withNewTemplateLike(JmxTransTemplate item) {
    return new TemplateNested(item);
  }
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new JmxTransTemplateBuilder().build()));
  }
  public TemplateNested<A> editOrNewTemplateLike(JmxTransTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JmxTransSpecFluent that = (JmxTransSpecFluent) o;
    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;

    if (!java.util.Objects.equals(outputDefinitions, that.outputDefinitions)) return false;

    if (!java.util.Objects.equals(kafkaQueries, that.kafkaQueries)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(image,  logLevel,  outputDefinitions,  kafkaQueries,  resources,  template,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (outputDefinitions != null && !outputDefinitions.isEmpty()) { sb.append("outputDefinitions:"); sb.append(outputDefinitions + ","); }
    if (kafkaQueries != null && !kafkaQueries.isEmpty()) { sb.append("kafkaQueries:"); sb.append(kafkaQueries + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (template != null) { sb.append("template:"); sb.append(template); }
    sb.append("}");
    return sb.toString();
  }
  public class OutputDefinitionsNested<N> extends JmxTransOutputDefinitionTemplateFluent<OutputDefinitionsNested<N>> implements Nested<N>{
    OutputDefinitionsNested(int index,JmxTransOutputDefinitionTemplate item) {
      this.index = index;
      this.builder = new JmxTransOutputDefinitionTemplateBuilder(this, item);
    }
    JmxTransOutputDefinitionTemplateBuilder builder;
    int index;
    public N and() {
      return (N) JmxTransSpecFluent.this.setToOutputDefinitions(index,builder.build());
    }
    public N endOutputDefinition() {
      return and();
    }
    
  }
  public class KafkaQueriesNested<N> extends JmxTransQueryTemplateFluent<KafkaQueriesNested<N>> implements Nested<N>{
    KafkaQueriesNested(int index,JmxTransQueryTemplate item) {
      this.index = index;
      this.builder = new JmxTransQueryTemplateBuilder(this, item);
    }
    JmxTransQueryTemplateBuilder builder;
    int index;
    public N and() {
      return (N) JmxTransSpecFluent.this.setToKafkaQueries(index,builder.build());
    }
    public N endKafkaQuery() {
      return and();
    }
    
  }
  public class TemplateNested<N> extends JmxTransTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(JmxTransTemplate item) {
      this.builder = new JmxTransTemplateBuilder(this, item);
    }
    JmxTransTemplateBuilder builder;
    public N and() {
      return (N) JmxTransSpecFluent.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}