package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EphemeralStorageBuilder extends EphemeralStorageFluent<EphemeralStorageBuilder> implements VisitableBuilder<EphemeralStorage,EphemeralStorageBuilder>{
  public EphemeralStorageBuilder() {
    this(false);
  }
  public EphemeralStorageBuilder(Boolean validationEnabled) {
    this(new EphemeralStorage(), validationEnabled);
  }
  public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent) {
    this(fluent, false);
  }
  public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EphemeralStorage(), validationEnabled);
  }
  public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent,EphemeralStorage instance) {
    this(fluent, instance, false);
  }
  public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent,EphemeralStorage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EphemeralStorage());

    if (instance != null) {
      fluent.withSizeLimit(instance.getSizeLimit());
      fluent.withId(instance.getId());
      fluent.withKraftMetadata(instance.getKraftMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EphemeralStorageBuilder(EphemeralStorage instance) {
    this(instance,false);
  }
  public EphemeralStorageBuilder(EphemeralStorage instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EphemeralStorage());

    if (instance != null) {
      this.withSizeLimit(instance.getSizeLimit());
      this.withId(instance.getId());
      this.withKraftMetadata(instance.getKraftMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  EphemeralStorageFluent<?> fluent;
  Boolean validationEnabled;
  public EphemeralStorage build() {
    EphemeralStorage buildable = new EphemeralStorage();
    buildable.setSizeLimit(fluent.getSizeLimit());
    buildable.setId(fluent.getId());
    buildable.setKraftMetadata(fluent.getKraftMetadata());
    return buildable;
  }
  
}