package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaAuthorizationCustomBuilder extends KafkaAuthorizationCustomFluent<KafkaAuthorizationCustomBuilder> implements VisitableBuilder<KafkaAuthorizationCustom,KafkaAuthorizationCustomBuilder>{
  public KafkaAuthorizationCustomBuilder() {
    this(false);
  }
  public KafkaAuthorizationCustomBuilder(Boolean validationEnabled) {
    this(new KafkaAuthorizationCustom(), validationEnabled);
  }
  public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaAuthorizationCustom(), validationEnabled);
  }
  public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent,KafkaAuthorizationCustom instance) {
    this(fluent, instance, false);
  }
  public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent,KafkaAuthorizationCustom instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaAuthorizationCustom());

    if (instance != null) {
      fluent.withAuthorizerClass(instance.getAuthorizerClass());
      fluent.withSuperUsers(instance.getSuperUsers());
      fluent.withSupportsAdminApi(instance.isSupportsAdminApi());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustom instance) {
    this(instance,false);
  }
  public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustom instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaAuthorizationCustom());

    if (instance != null) {
      this.withAuthorizerClass(instance.getAuthorizerClass());
      this.withSuperUsers(instance.getSuperUsers());
      this.withSupportsAdminApi(instance.isSupportsAdminApi());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaAuthorizationCustomFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaAuthorizationCustom build() {
    KafkaAuthorizationCustom buildable = new KafkaAuthorizationCustom();
    buildable.setAuthorizerClass(fluent.getAuthorizerClass());
    buildable.setSuperUsers(fluent.getSuperUsers());
    buildable.setSupportsAdminApi(fluent.isSupportsAdminApi());
    return buildable;
  }
  
}