package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KafkaAuthorizationKeycloakBuilder extends KafkaAuthorizationKeycloakFluent<KafkaAuthorizationKeycloakBuilder> implements VisitableBuilder<KafkaAuthorizationKeycloak,KafkaAuthorizationKeycloakBuilder>{
  public KafkaAuthorizationKeycloakBuilder() {
    this(false);
  }
  public KafkaAuthorizationKeycloakBuilder(Boolean validationEnabled) {
    this(new KafkaAuthorizationKeycloak(), validationEnabled);
  }
  public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloakFluent<?> fluent) {
    this(fluent, false);
  }
  public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloakFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KafkaAuthorizationKeycloak(), validationEnabled);
  }
  public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloakFluent<?> fluent,KafkaAuthorizationKeycloak instance) {
    this(fluent, instance, false);
  }
  public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloakFluent<?> fluent,KafkaAuthorizationKeycloak instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KafkaAuthorizationKeycloak());

    if (instance != null) {
      fluent.withClientId(instance.getClientId());
      fluent.withTokenEndpointUri(instance.getTokenEndpointUri());
      fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
      fluent.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
      fluent.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());
      fluent.withGrantsRefreshPeriodSeconds(instance.getGrantsRefreshPeriodSeconds());
      fluent.withGrantsRefreshPoolSize(instance.getGrantsRefreshPoolSize());
      fluent.withGrantsMaxIdleTimeSeconds(instance.getGrantsMaxIdleTimeSeconds());
      fluent.withGrantsGcPeriodSeconds(instance.getGrantsGcPeriodSeconds());
      fluent.withGrantsAlwaysLatest(instance.isGrantsAlwaysLatest());
      fluent.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
      fluent.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
      fluent.withHttpRetries(instance.getHttpRetries());
      fluent.withSuperUsers(instance.getSuperUsers());
      fluent.withEnableMetrics(instance.isEnableMetrics());
      fluent.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloak instance) {
    this(instance,false);
  }
  public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloak instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KafkaAuthorizationKeycloak());

    if (instance != null) {
      this.withClientId(instance.getClientId());
      this.withTokenEndpointUri(instance.getTokenEndpointUri());
      this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
      this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
      this.withDelegateToKafkaAcls(instance.isDelegateToKafkaAcls());
      this.withGrantsRefreshPeriodSeconds(instance.getGrantsRefreshPeriodSeconds());
      this.withGrantsRefreshPoolSize(instance.getGrantsRefreshPoolSize());
      this.withGrantsMaxIdleTimeSeconds(instance.getGrantsMaxIdleTimeSeconds());
      this.withGrantsGcPeriodSeconds(instance.getGrantsGcPeriodSeconds());
      this.withGrantsAlwaysLatest(instance.isGrantsAlwaysLatest());
      this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
      this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
      this.withHttpRetries(instance.getHttpRetries());
      this.withSuperUsers(instance.getSuperUsers());
      this.withEnableMetrics(instance.isEnableMetrics());
      this.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
    }
    this.validationEnabled = validationEnabled; 
  }
  KafkaAuthorizationKeycloakFluent<?> fluent;
  Boolean validationEnabled;
  public KafkaAuthorizationKeycloak build() {
    KafkaAuthorizationKeycloak buildable = new KafkaAuthorizationKeycloak();
    buildable.setClientId(fluent.getClientId());
    buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
    buildable.setTlsTrustedCertificates(fluent.buildTlsTrustedCertificates());
    buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
    buildable.setDelegateToKafkaAcls(fluent.isDelegateToKafkaAcls());
    buildable.setGrantsRefreshPeriodSeconds(fluent.getGrantsRefreshPeriodSeconds());
    buildable.setGrantsRefreshPoolSize(fluent.getGrantsRefreshPoolSize());
    buildable.setGrantsMaxIdleTimeSeconds(fluent.getGrantsMaxIdleTimeSeconds());
    buildable.setGrantsGcPeriodSeconds(fluent.getGrantsGcPeriodSeconds());
    buildable.setGrantsAlwaysLatest(fluent.isGrantsAlwaysLatest());
    buildable.setConnectTimeoutSeconds(fluent.getConnectTimeoutSeconds());
    buildable.setReadTimeoutSeconds(fluent.getReadTimeoutSeconds());
    buildable.setHttpRetries(fluent.getHttpRetries());
    buildable.setSuperUsers(fluent.getSuperUsers());
    buildable.setEnableMetrics(fluent.isEnableMetrics());
    buildable.setIncludeAcceptHeader(fluent.isIncludeAcceptHeader());
    return buildable;
  }
  
}